/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.StreamCache;

public class TempFileStreamCache
implements StreamCache {
    private OutputStream output;
    private File tempFile = File.createTempFile("org.apache.fop.pdf.StreamCache-", ".temp");

    public TempFileStreamCache() throws IOException {
        this.tempFile.deleteOnExit();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        }
        return this.output;
    }

    public void write(byte[] byArray) throws IOException {
        this.getOutputStream().write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outputContents(OutputStream outputStream) throws IOException {
        if (this.output == null) {
            return 0;
        }
        this.output.close();
        this.output = null;
        FileInputStream fileInputStream = new FileInputStream(this.tempFile);
        try {
            int n = IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            return n;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    public int getSize() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
        return (int)this.tempFile.length();
    }

    public void clear() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }
}

