/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf.xref;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.xref.CompressedObjectReference;
import org.apache.fop.pdf.xref.CrossReferenceObject;
import org.apache.fop.pdf.xref.ObjectReference;
import org.apache.fop.pdf.xref.TrailerDictionary;
import org.apache.fop.pdf.xref.UncompressedObjectReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceStream
extends CrossReferenceObject {
    private static final PDFName XREF = new PDFName("XRef");
    private final PDFDocument document;
    private final int objectNumber;
    private final List<ObjectReference> objectReferences;

    public CrossReferenceStream(PDFDocument pDFDocument, int n, TrailerDictionary trailerDictionary, long l, List<Long> list, List<CompressedObjectReference> list2) {
        super(trailerDictionary, l);
        this.document = pDFDocument;
        this.objectNumber = n;
        this.objectReferences = new ArrayList<ObjectReference>(list.size());
        for (Long object : list) {
            this.objectReferences.add(object == null ? null : new UncompressedObjectReference(object));
        }
        for (CompressedObjectReference compressedObjectReference : list2) {
            this.objectReferences.set(compressedObjectReference.getObjectNumber() - 1, compressedObjectReference);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.populateDictionary();
        PDFStream pDFStream = new PDFStream(this.trailerDictionary.getDictionary(), false){

            protected void setupFilterList() {
                PDFFilterList pDFFilterList = this.getFilterList();
                assert (!pDFFilterList.isInitialized());
                pDFFilterList.addDefaultFilters(CrossReferenceStream.this.document.getFilterMap(), this.getDefaultFilterName());
            }
        };
        pDFStream.setObjectNumber(this.objectNumber);
        pDFStream.setDocument(this.document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.addFreeEntryForObject0(dataOutputStream);
        for (ObjectReference objectReference : this.objectReferences) {
            assert (objectReference != null);
            objectReference.output(dataOutputStream);
        }
        new UncompressedObjectReference(this.startxref).output(dataOutputStream);
        dataOutputStream.close();
        pDFStream.setData(byteArrayOutputStream.toByteArray());
        PDFDocument.outputIndirectObject(pDFStream, outputStream);
    }

    private void populateDictionary() throws IOException {
        int n = this.objectReferences.size() + 1;
        PDFDictionary pDFDictionary = this.trailerDictionary.getDictionary();
        pDFDictionary.put("/Type", XREF);
        pDFDictionary.put("/Size", n + 1);
        pDFDictionary.put("/W", new PDFArray(1, 8, 2));
    }

    private void addFreeEntryForObject0(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1});
    }
}

