/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf.xref;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryption;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFWritable;

public class TrailerDictionary {
    private final PDFDictionary dictionary = new PDFDictionary();

    public TrailerDictionary(PDFDocument pDFDocument) {
        this.dictionary.setDocument(pDFDocument);
    }

    public TrailerDictionary setRoot(PDFRoot pDFRoot) {
        this.dictionary.put("/Root", pDFRoot);
        return this;
    }

    public TrailerDictionary setInfo(PDFInfo pDFInfo) {
        this.dictionary.put("/Info", pDFInfo);
        return this;
    }

    public TrailerDictionary setEncryption(PDFEncryption pDFEncryption) {
        this.dictionary.put("/Encrypt", pDFEncryption);
        return this;
    }

    public TrailerDictionary setFileID(byte[] byArray, byte[] byArray2) {
        class FileID
        implements PDFWritable {
            private final byte[] fileID;

            FileID(byte[] byArray) {
                this.fileID = byArray;
            }

            public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
                PDFDocument.flushTextBuffer(stringBuilder, outputStream);
                String string = PDFText.toHex(this.fileID, true);
                byte[] byArray = string.getBytes("US-ASCII");
                outputStream.write(byArray);
            }
        }
        PDFArray pDFArray = new PDFArray(new FileID(byArray), new FileID(byArray2));
        this.dictionary.put("/ID", pDFArray);
        return this;
    }

    PDFDictionary getDictionary() {
        return this.dictionary;
    }
}

