/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.render.AbstractFOEventHandlerMaker;
import org.apache.fop.render.AbstractRendererMaker;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;
import org.apache.fop.render.intermediate.AbstractIFDocumentHandlerMaker;
import org.apache.fop.render.intermediate.EventProducingFilter;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFRenderer;
import org.apache.xmlgraphics.util.Service;

public class RendererFactory {
    private static Log log = LogFactory.getLog(RendererFactory.class);
    private Map rendererMakerMapping = new HashMap();
    private Map eventHandlerMakerMapping = new HashMap();
    private Map documentHandlerMakerMapping = new HashMap();
    private boolean rendererPreferred = false;

    public RendererFactory() {
        this.discoverRenderers();
        this.discoverFOEventHandlers();
        this.discoverDocumentHandlers();
    }

    public void setRendererPreferred(boolean bl) {
        this.rendererPreferred = bl;
    }

    public boolean isRendererPreferred() {
        return this.rendererPreferred;
    }

    public void addRendererMaker(AbstractRendererMaker abstractRendererMaker) {
        String[] stringArray = abstractRendererMaker.getSupportedMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.rendererMakerMapping.get(stringArray[i]) != null) {
                log.trace((Object)("Overriding renderer for " + stringArray[i] + " with " + abstractRendererMaker.getClass().getName()));
            }
            this.rendererMakerMapping.put(stringArray[i], abstractRendererMaker);
        }
    }

    public void addFOEventHandlerMaker(AbstractFOEventHandlerMaker abstractFOEventHandlerMaker) {
        String[] stringArray = abstractFOEventHandlerMaker.getSupportedMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.eventHandlerMakerMapping.get(stringArray[i]) != null) {
                log.trace((Object)("Overriding FOEventHandler for " + stringArray[i] + " with " + abstractFOEventHandlerMaker.getClass().getName()));
            }
            this.eventHandlerMakerMapping.put(stringArray[i], abstractFOEventHandlerMaker);
        }
    }

    public void addDocumentHandlerMaker(AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker) {
        String[] stringArray = abstractIFDocumentHandlerMaker.getSupportedMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.documentHandlerMakerMapping.get(stringArray[i]) != null) {
                log.trace((Object)("Overriding document handler for " + stringArray[i] + " with " + abstractIFDocumentHandlerMaker.getClass().getName()));
            }
            this.documentHandlerMakerMapping.put(stringArray[i], abstractIFDocumentHandlerMaker);
        }
    }

    public void addRendererMaker(String string) {
        try {
            AbstractRendererMaker abstractRendererMaker = (AbstractRendererMaker)Class.forName(string).newInstance();
            this.addRendererMaker(abstractRendererMaker);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + AbstractRendererMaker.class.getName());
        }
    }

    public void addFOEventHandlerMaker(String string) {
        try {
            AbstractFOEventHandlerMaker abstractFOEventHandlerMaker = (AbstractFOEventHandlerMaker)Class.forName(string).newInstance();
            this.addFOEventHandlerMaker(abstractFOEventHandlerMaker);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + AbstractFOEventHandlerMaker.class.getName());
        }
    }

    public void addDocumentHandlerMaker(String string) {
        try {
            AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = (AbstractIFDocumentHandlerMaker)Class.forName(string).newInstance();
            this.addDocumentHandlerMaker(abstractIFDocumentHandlerMaker);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + AbstractIFDocumentHandlerMaker.class.getName());
        }
    }

    public AbstractRendererMaker getRendererMaker(String string) {
        AbstractRendererMaker abstractRendererMaker = (AbstractRendererMaker)this.rendererMakerMapping.get(string);
        return abstractRendererMaker;
    }

    public AbstractFOEventHandlerMaker getFOEventHandlerMaker(String string) {
        AbstractFOEventHandlerMaker abstractFOEventHandlerMaker = (AbstractFOEventHandlerMaker)this.eventHandlerMakerMapping.get(string);
        return abstractFOEventHandlerMaker;
    }

    public AbstractIFDocumentHandlerMaker getDocumentHandlerMaker(String string) {
        AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = (AbstractIFDocumentHandlerMaker)this.documentHandlerMakerMapping.get(string);
        return abstractIFDocumentHandlerMaker;
    }

    public Renderer createRenderer(FOUserAgent fOUserAgent, String string) throws FOPException {
        Renderer renderer;
        if (fOUserAgent.getDocumentHandlerOverride() != null) {
            return this.createRendererForDocumentHandler(fOUserAgent.getDocumentHandlerOverride());
        }
        if (fOUserAgent.getRendererOverride() != null) {
            return fOUserAgent.getRendererOverride();
        }
        if (this.isRendererPreferred()) {
            renderer = this.tryRendererMaker(fOUserAgent, string);
            if (renderer == null) {
                renderer = this.tryIFDocumentHandlerMaker(fOUserAgent, string);
            }
        } else {
            renderer = this.tryIFDocumentHandlerMaker(fOUserAgent, string);
            if (renderer == null) {
                renderer = this.tryRendererMaker(fOUserAgent, string);
            }
        }
        if (renderer == null) {
            throw new UnsupportedOperationException("No renderer for the requested format available: " + string);
        }
        return renderer;
    }

    private Renderer tryIFDocumentHandlerMaker(FOUserAgent fOUserAgent, String string) throws FOPException {
        AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = this.getDocumentHandlerMaker(string);
        if (abstractIFDocumentHandlerMaker != null) {
            IFDocumentHandler iFDocumentHandler = this.createDocumentHandler(fOUserAgent, string);
            return this.createRendererForDocumentHandler(iFDocumentHandler);
        }
        return null;
    }

    private Renderer tryRendererMaker(FOUserAgent fOUserAgent, String string) throws FOPException {
        AbstractRendererMaker abstractRendererMaker = this.getRendererMaker(string);
        if (abstractRendererMaker != null) {
            Renderer renderer = abstractRendererMaker.makeRenderer(fOUserAgent);
            RendererConfigurator rendererConfigurator = abstractRendererMaker.getConfigurator(fOUserAgent);
            if (rendererConfigurator != null) {
                rendererConfigurator.configure(renderer);
            }
            return renderer;
        }
        return null;
    }

    private Renderer createRendererForDocumentHandler(IFDocumentHandler iFDocumentHandler) {
        IFRenderer iFRenderer = new IFRenderer(iFDocumentHandler.getContext().getUserAgent());
        iFRenderer.setDocumentHandler(iFDocumentHandler);
        return iFRenderer;
    }

    public FOEventHandler createFOEventHandler(FOUserAgent fOUserAgent, String string, OutputStream outputStream) throws FOPException {
        boolean bl;
        if (fOUserAgent.getFOEventHandlerOverride() != null) {
            return fOUserAgent.getFOEventHandlerOverride();
        }
        AbstractFOEventHandlerMaker abstractFOEventHandlerMaker = this.getFOEventHandlerMaker(string);
        if (abstractFOEventHandlerMaker != null) {
            return abstractFOEventHandlerMaker.makeFOEventHandler(fOUserAgent, outputStream);
        }
        AbstractRendererMaker abstractRendererMaker = this.getRendererMaker(string);
        AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = null;
        boolean bl2 = bl = fOUserAgent.getRendererOverride() == null && fOUserAgent.getDocumentHandlerOverride() == null;
        if (abstractRendererMaker == null) {
            abstractIFDocumentHandlerMaker = this.getDocumentHandlerMaker(string);
            if (abstractIFDocumentHandlerMaker != null) {
                bl &= outputStream == null && abstractIFDocumentHandlerMaker.needsOutputStream();
            }
        } else {
            bl &= outputStream == null && abstractRendererMaker.needsOutputStream();
        }
        if (fOUserAgent.getRendererOverride() != null || abstractRendererMaker != null || fOUserAgent.getDocumentHandlerOverride() != null || abstractIFDocumentHandlerMaker != null) {
            if (bl) {
                throw new FOPException("OutputStream has not been set");
            }
            return new AreaTreeHandler(fOUserAgent, string, outputStream);
        }
        throw new UnsupportedOperationException("Don't know how to handle \"" + string + "\" as an output format." + " Neither an FOEventHandler, nor a Renderer could be found" + " for this output format.");
    }

    public IFDocumentHandler createDocumentHandler(FOUserAgent fOUserAgent, String string) throws FOPException {
        if (fOUserAgent.getDocumentHandlerOverride() != null) {
            return fOUserAgent.getDocumentHandlerOverride();
        }
        AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = this.getDocumentHandlerMaker(string);
        if (abstractIFDocumentHandlerMaker == null) {
            throw new UnsupportedOperationException("No IF document handler for the requested format available: " + string);
        }
        IFDocumentHandler iFDocumentHandler = abstractIFDocumentHandlerMaker.makeIFDocumentHandler(fOUserAgent);
        IFDocumentHandlerConfigurator iFDocumentHandlerConfigurator = iFDocumentHandler.getConfigurator();
        if (iFDocumentHandlerConfigurator != null) {
            iFDocumentHandlerConfigurator.configure(iFDocumentHandler);
        }
        return new EventProducingFilter(iFDocumentHandler, fOUserAgent);
    }

    public String[] listSupportedMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.rendererMakerMapping.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        iterator = this.eventHandlerMakerMapping.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        iterator = this.documentHandlerMakerMapping.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void discoverRenderers() {
        Iterator iterator = Service.providers(Renderer.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                AbstractRendererMaker abstractRendererMaker = (AbstractRendererMaker)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding maker for Renderer: " + abstractRendererMaker.getClass().getName()));
                    }
                    this.addRendererMaker(abstractRendererMaker);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding maker for Renderer", (Throwable)illegalArgumentException);
                }
            }
        }
    }

    private void discoverFOEventHandlers() {
        Iterator iterator = Service.providers(FOEventHandler.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                AbstractFOEventHandlerMaker abstractFOEventHandlerMaker = (AbstractFOEventHandlerMaker)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding maker for FOEventHandler: " + abstractFOEventHandlerMaker.getClass().getName()));
                    }
                    this.addFOEventHandlerMaker(abstractFOEventHandlerMaker);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding maker for FOEventHandler", (Throwable)illegalArgumentException);
                }
            }
        }
    }

    private void discoverDocumentHandlers() {
        Iterator iterator = Service.providers(IFDocumentHandler.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                AbstractIFDocumentHandlerMaker abstractIFDocumentHandlerMaker = (AbstractIFDocumentHandlerMaker)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding maker for IFDocumentHandler: " + abstractIFDocumentHandlerMaker.getClass().getName()));
                    }
                    this.addDocumentHandlerMaker(abstractIFDocumentHandlerMaker);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding maker for IFDocumentHandler", (Throwable)illegalArgumentException);
                }
            }
        }
    }
}

