/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.XMLHandler;
import org.apache.xmlgraphics.util.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLHandlerRegistry {
    private static Log log = LogFactory.getLog(XMLHandlerRegistry.class);
    private Map<String, List<XMLHandler>> handlers = new HashMap<String, List<XMLHandler>>();

    public XMLHandlerRegistry() {
        this.discoverXMLHandlers();
    }

    private void setDefaultXMLHandler(XMLHandler xMLHandler) {
        this.addXMLHandler("*", xMLHandler);
    }

    public void addXMLHandler(String string) {
        try {
            XMLHandler xMLHandler = (XMLHandler)Class.forName(string).newInstance();
            this.addXMLHandler(xMLHandler);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an " + XMLHandler.class.getName());
        }
    }

    public void addXMLHandler(XMLHandler xMLHandler) {
        String string = xMLHandler.getNamespace();
        if (string == null) {
            this.setDefaultXMLHandler(xMLHandler);
        } else {
            this.addXMLHandler(string, xMLHandler);
        }
    }

    private void addXMLHandler(String string, XMLHandler xMLHandler) {
        List<XMLHandler> list = this.handlers.get(string);
        if (list == null) {
            list = new ArrayList<XMLHandler>();
            this.handlers.put(string, list);
        }
        list.add(xMLHandler);
    }

    public XMLHandler getXMLHandler(Renderer renderer, String string) {
        List<XMLHandler> list = this.handlers.get(string);
        XMLHandler xMLHandler = this.getXMLHandler(renderer, list);
        if (xMLHandler == null) {
            list = this.handlers.get("*");
            xMLHandler = this.getXMLHandler(renderer, list);
        }
        return xMLHandler;
    }

    private XMLHandler getXMLHandler(Renderer renderer, List<XMLHandler> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                XMLHandler xMLHandler = list.get(i);
                if (!xMLHandler.supportsRenderer(renderer)) continue;
                return xMLHandler;
            }
        }
        return null;
    }

    private void discoverXMLHandlers() {
        Iterator iterator = Service.providers(XMLHandler.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                XMLHandler xMLHandler = (XMLHandler)iterator.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dynamically adding XMLHandler: " + xMLHandler.getClass().getName()));
                    }
                    this.addXMLHandler(xMLHandler);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)"Error while adding XMLHandler", (Throwable)illegalArgumentException);
                }
            }
        }
    }
}

