/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandler;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public abstract class AbstractAFPImageHandlerRawStream
extends AFPImageHandler
implements ImageHandler {
    protected void setAdditionalParameters(AFPDataObjectInfo aFPDataObjectInfo, ImageRawStream imageRawStream) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataObjectInfo(AFPDataObjectInfo aFPDataObjectInfo, ImageRawStream imageRawStream, AFPResourceManager aFPResourceManager) throws IOException {
        aFPDataObjectInfo.setMimeType(imageRawStream.getFlavor().getMimeType());
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        if (!aFPResourceInfo.levelChanged()) {
            aFPResourceInfo.setLevel(aFPResourceManager.getResourceLevelDefaults().getDefaultResourceLevel((byte)6));
        }
        InputStream inputStream = imageRawStream.createInputStream();
        try {
            aFPDataObjectInfo.setData(IOUtils.toByteArray((InputStream)inputStream));
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        int n = imageRawStream.getSize().getHeightPx();
        aFPDataObjectInfo.setDataHeight(n);
        int n2 = imageRawStream.getSize().getWidthPx();
        aFPDataObjectInfo.setDataWidth(n2);
        ImageSize imageSize = imageRawStream.getSize();
        aFPDataObjectInfo.setDataHeightRes((int)(imageSize.getDpiHorizontal() * 10.0));
        aFPDataObjectInfo.setDataWidthRes((int)(imageSize.getDpiVertical() * 10.0));
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        AFPRenderingContext aFPRenderingContext = (AFPRenderingContext)renderingContext;
        AFPDataObjectInfo aFPDataObjectInfo = this.createDataObjectInfo();
        this.setResourceInformation(aFPDataObjectInfo, image.getInfo().getOriginalURI(), aFPRenderingContext.getForeignAttributes());
        aFPDataObjectInfo.setObjectAreaInfo(AbstractAFPImageHandlerRawStream.createObjectAreaInfo(aFPRenderingContext.getPaintingState(), rectangle));
        AFPPaintingState aFPPaintingState = aFPRenderingContext.getPaintingState();
        int n = aFPPaintingState.getResolution();
        AFPObjectAreaInfo aFPObjectAreaInfo = aFPDataObjectInfo.getObjectAreaInfo();
        aFPObjectAreaInfo.setResolution(n);
        ImageRawStream imageRawStream = (ImageRawStream)image;
        this.updateDataObjectInfo(aFPDataObjectInfo, imageRawStream, aFPRenderingContext.getResourceManager());
        this.setAdditionalParameters(aFPDataObjectInfo, imageRawStream);
        aFPRenderingContext.getResourceManager().createObject(aFPDataObjectInfo);
    }
}

