/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.extensions.AFPExtensionAttachment;
import org.apache.fop.render.afp.extensions.AFPIncludeFormMap;
import org.apache.fop.render.afp.extensions.AFPInvokeMediumMap;
import org.apache.fop.render.afp.extensions.AFPPageOverlay;
import org.apache.fop.render.afp.extensions.AFPPageSegmentElement;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.extensions.ExtensionPlacement;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class AFPExtensionHandler
extends DefaultHandler
implements ContentHandlerFactory.ObjectSource {
    protected static final Log log = LogFactory.getLog(AFPExtensionHandler.class);
    private StringBuffer content = new StringBuffer();
    private Attributes lastAttributes;
    private AFPExtensionAttachment returnedObject;
    private ContentHandlerFactory.ObjectBuiltListener listener;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        if ("apache:fop:extensions:afp".equals(string)) {
            this.lastAttributes = new AttributesImpl(attributes);
            bl = true;
            if (!(string2.equals("no-operation") || string2.equals("tag-logical-element") || string2.equals("include-page-overlay") || string2.equals("include-page-segment") || string2.equals("include-form-map") || string2.equals("invoke-medium-map"))) {
                bl = false;
            }
        }
        if (!bl) {
            if ("apache:fop:extensions:afp".equals(string)) {
                throw new SAXException("Unhandled element " + string2 + " in namespace: " + string);
            }
            log.warn((Object)("Unhandled element " + string2 + " in namespace: " + string));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("apache:fop:extensions:afp".equals(string)) {
            if ("include-form-map".equals(string2)) {
                AFPIncludeFormMap aFPIncludeFormMap = new AFPIncludeFormMap();
                String string4 = this.lastAttributes.getValue("name");
                aFPIncludeFormMap.setName(string4);
                String string5 = this.lastAttributes.getValue("src");
                try {
                    aFPIncludeFormMap.setSrc(new URI(string5));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new SAXException("Invalid URI: " + string5, uRISyntaxException);
                }
                this.returnedObject = aFPIncludeFormMap;
            } else if ("include-page-overlay".equals(string2)) {
                this.returnedObject = new AFPPageOverlay();
                String string6 = this.lastAttributes.getValue("name");
                if (string6 != null) {
                    this.returnedObject.setName(string6);
                }
            } else if ("include-page-segment".equals(string2)) {
                String string7;
                String string8;
                AFPPageSegmentElement.AFPPageSegmentSetup aFPPageSegmentSetup = null;
                aFPPageSegmentSetup = new AFPPageSegmentElement.AFPPageSegmentSetup(string2);
                this.returnedObject = aFPPageSegmentSetup;
                String string9 = this.lastAttributes.getValue("name");
                if (string9 != null) {
                    this.returnedObject.setName(string9);
                }
                if ((string8 = this.lastAttributes.getValue("value")) != null && aFPPageSegmentSetup != null) {
                    aFPPageSegmentSetup.setValue(string8);
                }
                if ((string7 = this.lastAttributes.getValue("resource-file")) != null && aFPPageSegmentSetup != null) {
                    aFPPageSegmentSetup.setResourceSrc(string7);
                }
                if (this.content.length() > 0 && aFPPageSegmentSetup != null) {
                    aFPPageSegmentSetup.setContent(this.content.toString());
                    this.content.setLength(0);
                }
            } else {
                String string10;
                String string11;
                AFPPageSetup aFPPageSetup = null;
                if ("invoke-medium-map".equals(string2)) {
                    this.returnedObject = new AFPInvokeMediumMap();
                } else {
                    aFPPageSetup = new AFPPageSetup(string2);
                    this.returnedObject = aFPPageSetup;
                }
                String string12 = this.lastAttributes.getValue("name");
                if (string12 != null) {
                    this.returnedObject.setName(string12);
                }
                if ((string11 = this.lastAttributes.getValue("value")) != null && aFPPageSetup != null) {
                    aFPPageSetup.setValue(string11);
                }
                if ((string10 = this.lastAttributes.getValue("placement")) != null && string10.length() > 0) {
                    aFPPageSetup.setPlacement(ExtensionPlacement.fromXMLValue(string10));
                }
                if (this.content.length() > 0 && aFPPageSetup != null) {
                    aFPPageSetup.setContent(this.content.toString());
                    this.content.setLength(0);
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.content.append(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        if (this.listener != null) {
            this.listener.notifyObjectBuilt(this.getObject());
        }
    }

    public Object getObject() {
        return this.returnedObject;
    }

    public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener objectBuiltListener) {
        this.listener = objectBuiltListener;
    }
}

