/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.afp.extensions.AFPPageSetup;
import org.apache.fop.render.afp.extensions.AFPPageSetupElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AFPPageSegmentElement
extends AFPPageSetupElement {
    private static final String ATT_RESOURCE_SRC = "resource-file";

    public AFPPageSegmentElement(FONode fONode, String string) {
        super(fONode, string);
    }

    private AFPPageSegmentSetup getPageSetupAttachment() {
        return (AFPPageSegmentSetup)this.getExtensionAttachment();
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        AFPPageSegmentSetup aFPPageSegmentSetup = this.getPageSetupAttachment();
        super.processNode(string, locator, attributes, propertyList);
        String string2 = attributes.getValue(ATT_RESOURCE_SRC);
        if (string2 != null && string2.length() > 0) {
            aFPPageSegmentSetup.setResourceSrc(string2);
        }
    }

    protected ExtensionAttachment instantiateExtensionAttachment() {
        return new AFPPageSegmentSetup(this.getLocalName());
    }

    public static class AFPPageSegmentSetup
    extends AFPPageSetup {
        private static final long serialVersionUID = 1L;
        private String resourceSrc;

        public AFPPageSegmentSetup(String string) {
            super(string);
        }

        public String getResourceSrc() {
            return this.resourceSrc;
        }

        public void setResourceSrc(String string) {
            this.resourceSrc = string.trim();
        }

        public void toSAX(ContentHandler contentHandler) throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl();
            if (this.name != null && this.name.length() > 0) {
                attributesImpl.addAttribute(null, "name", "name", "CDATA", this.name);
            }
            if (this.value != null && this.value.length() > 0) {
                attributesImpl.addAttribute(null, "value", "value", "CDATA", this.value);
            }
            if (this.resourceSrc != null && this.resourceSrc.length() > 0) {
                attributesImpl.addAttribute(null, AFPPageSegmentElement.ATT_RESOURCE_SRC, AFPPageSegmentElement.ATT_RESOURCE_SRC, "CDATA", this.resourceSrc);
            }
            contentHandler.startElement("apache:fop:extensions:afp", this.elementName, this.elementName, attributesImpl);
            if (this.content != null && this.content.length() > 0) {
                char[] cArray = this.content.toCharArray();
                contentHandler.characters(cArray, 0, cArray.length);
            }
            contentHandler.endElement("apache:fop:extensions:afp", this.elementName, this.elementName);
        }

        public String toString() {
            return "AFPPageSegmentSetup(element-name=" + this.getElementName() + " name=" + this.getName() + " value=" + this.getValue() + " resource=" + this.getResourceSrc() + ")";
        }
    }
}

