/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.extensions.prepress;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.xmlgraphics.util.QName;

public class PageBoundaries {
    public static final QName EXT_BLEED = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "bleed");
    public static final QName EXT_CROP_OFFSET = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "crop-offset");
    public static final QName EXT_CROP_BOX = new QName("http://xmlgraphics.apache.org/fop/extensions", null, "crop-box");
    private static final Pattern SIZE_UNIT_PATTERN = Pattern.compile("^(-?\\d*\\.?\\d*)(px|in|cm|mm|pt|pc|mpt)$");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private Rectangle trimBox;
    private Rectangle bleedBox;
    private Rectangle mediaBox;
    private Rectangle cropBox;

    public PageBoundaries(Dimension dimension, String string, String string2, String string3) {
        this.calculate(dimension, string, string2, string3);
    }

    public PageBoundaries(Dimension dimension, Map map) {
        String string = (String)map.get(EXT_BLEED);
        String string2 = (String)map.get(EXT_CROP_OFFSET);
        String string3 = (String)map.get(EXT_CROP_BOX);
        this.calculate(dimension, string, string2, string3);
    }

    private void calculate(Dimension dimension, String string, String string2, String string3) {
        this.trimBox = new Rectangle(dimension);
        this.bleedBox = PageBoundaries.getBleedBoxRectangle(this.trimBox, string);
        Rectangle rectangle = PageBoundaries.getCropMarksAreaRectangle(this.trimBox, string2);
        this.mediaBox = new Rectangle();
        this.mediaBox.add(this.trimBox);
        this.mediaBox.add(this.bleedBox);
        this.mediaBox.add(rectangle);
        if ("trim-box".equals(string3)) {
            this.cropBox = this.trimBox;
        } else if ("bleed-box".equals(string3)) {
            this.cropBox = this.bleedBox;
        } else if ("media-box".equals(string3) || string3 == null || "".equals(string3)) {
            this.cropBox = this.mediaBox;
        } else {
            throw new IllegalArgumentException(MessageFormat.format("The crop-box has invalid value: {0}, possible values of crop-box: (trim-box|bleed-box|media-box)", string3));
        }
    }

    public Rectangle getTrimBox() {
        return this.trimBox;
    }

    public Rectangle getBleedBox() {
        return this.bleedBox;
    }

    public Rectangle getMediaBox() {
        return this.mediaBox;
    }

    public Rectangle getCropBox() {
        return this.cropBox;
    }

    private static Rectangle getBleedBoxRectangle(Rectangle rectangle, String string) {
        return PageBoundaries.getRectangleUsingOffset(rectangle, string);
    }

    private static Rectangle getCropMarksAreaRectangle(Rectangle rectangle, String string) {
        return PageBoundaries.getRectangleUsingOffset(rectangle, string);
    }

    private static Rectangle getRectangleUsingOffset(Rectangle rectangle, String string) {
        if (string == null || "".equals(string) || rectangle == null) {
            return rectangle;
        }
        String[] stringArray = WHITESPACE_PATTERN.split(string);
        int[] nArray = new int[4];
        switch (stringArray.length) {
            case 1: {
                nArray[0] = PageBoundaries.getLengthIntValue(stringArray[0]);
                nArray[1] = nArray[0];
                nArray[2] = nArray[0];
                nArray[3] = nArray[0];
                break;
            }
            case 2: {
                nArray[0] = PageBoundaries.getLengthIntValue(stringArray[0]);
                nArray[1] = PageBoundaries.getLengthIntValue(stringArray[1]);
                nArray[2] = nArray[0];
                nArray[3] = nArray[1];
                break;
            }
            case 3: {
                nArray[0] = PageBoundaries.getLengthIntValue(stringArray[0]);
                nArray[1] = PageBoundaries.getLengthIntValue(stringArray[1]);
                nArray[2] = PageBoundaries.getLengthIntValue(stringArray[2]);
                nArray[3] = nArray[1];
                break;
            }
            case 4: {
                nArray[0] = PageBoundaries.getLengthIntValue(stringArray[0]);
                nArray[1] = PageBoundaries.getLengthIntValue(stringArray[1]);
                nArray[2] = PageBoundaries.getLengthIntValue(stringArray[2]);
                nArray[3] = PageBoundaries.getLengthIntValue(stringArray[3]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many arguments");
            }
        }
        return new Rectangle(rectangle.x - nArray[3], rectangle.y - nArray[0], rectangle.width + nArray[3] + nArray[1], rectangle.height + nArray[0] + nArray[2]);
    }

    private static int getLengthIntValue(String string) {
        Matcher matcher = SIZE_UNIT_PATTERN.matcher(string);
        if (matcher.find()) {
            return FixedLength.getInstance(Double.parseDouble(matcher.group(1)), matcher.group(2)).getLength().getValue();
        }
        throw new IllegalArgumentException(MessageFormat.format("Incorrect length value: {0}", string));
    }
}

