/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.render.intermediate.AbstractIFDocumentHandler;
import org.apache.fop.render.intermediate.IFException;

public abstract class AbstractBinaryWritingIFDocumentHandler
extends AbstractIFDocumentHandler {
    protected OutputStream outputStream;
    private boolean ownOutputStream;
    protected FontInfo fontInfo;

    public void setResult(Result result) throws IFException {
        OutputStream outputStream;
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            outputStream = streamResult.getOutputStream();
            if (outputStream == null) {
                if (streamResult.getWriter() != null) {
                    throw new IllegalArgumentException("FOP cannot use a Writer. Please supply an OutputStream!");
                }
                try {
                    URL uRL = new URL(streamResult.getSystemId());
                    File file = FileUtils.toFile((URL)uRL);
                    outputStream = file != null ? new FileOutputStream(file) : uRL.openConnection().getOutputStream();
                }
                catch (IOException iOException) {
                    throw new IFException("I/O error while opening output stream", iOException);
                }
                outputStream = new BufferedOutputStream(outputStream);
                this.ownOutputStream = true;
            }
            if (outputStream == null) {
                throw new IllegalArgumentException("Need a StreamResult with an OutputStream");
            }
        } else {
            throw new UnsupportedOperationException("Unsupported Result subclass: " + result.getClass().getName());
        }
        this.outputStream = outputStream;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontManager fontManager = this.getUserAgent().getFactory().getFontManager();
        FontCollection[] fontCollectionArray = new FontCollection[]{new Base14FontCollection(fontManager.isBase14KerningEnabled())};
        FontInfo fontInfo2 = fontInfo != null ? fontInfo : new FontInfo();
        fontInfo2.setEventListener(new FontEventAdapter(this.getUserAgent().getEventBroadcaster()));
        fontManager.setup(fontInfo2, fontCollectionArray);
        this.setFontInfo(fontInfo2);
    }

    public void startDocument() throws IFException {
        super.startDocument();
        if (this.outputStream == null) {
            throw new IllegalStateException("OutputStream hasn't been set through setResult()");
        }
    }

    public void endDocument() throws IFException {
        if (this.ownOutputStream) {
            IOUtils.closeQuietly((OutputStream)this.outputStream);
            this.outputStream = null;
        }
    }
}

