/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class URIAction
extends AbstractAction
implements DocumentNavigationExtensionConstants {
    private String uri;
    private boolean newWindow;

    public URIAction(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("uri must not be null");
        }
        this.uri = string;
        this.newWindow = bl;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isNewWindow() {
        return this.newWindow;
    }

    public boolean isSame(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new NullPointerException("other must not be null");
        }
        if (!(abstractAction instanceof URIAction)) {
            return false;
        }
        URIAction uRIAction = (URIAction)abstractAction;
        if (!this.getURI().equals(uRIAction.getURI())) {
            return false;
        }
        return this.isNewWindow() == uRIAction.isNewWindow();
    }

    public String getIDPrefix() {
        return "fop-" + GOTO_URI.getLocalName();
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (this.hasID()) {
            attributesImpl.addAttribute(null, "id", "id", "CDATA", this.getID());
        }
        attributesImpl.addAttribute(null, "uri", "uri", "CDATA", this.getURI());
        if (this.isNewWindow()) {
            attributesImpl.addAttribute(null, "show-destination", "show-destination", "CDATA", "new");
        }
        contentHandler.startElement(GOTO_URI.getNamespaceURI(), GOTO_URI.getLocalName(), GOTO_URI.getQName(), attributesImpl);
        contentHandler.endElement(GOTO_URI.getNamespaceURI(), GOTO_URI.getLocalName(), GOTO_URI.getQName());
    }
}

