/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.java2d.Java2DRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;

public class Java2DImageHandlerRenderedImage
implements ImageHandler {
    public int getPriority() {
        return 300;
    }

    public Class getSupportedImageClass() {
        return ImageRendered.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.BUFFERED_IMAGE, ImageFlavor.RENDERED_IMAGE};
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        Java2DRenderingContext java2DRenderingContext = (Java2DRenderingContext)renderingContext;
        ImageInfo imageInfo = image.getInfo();
        ImageRendered imageRendered = (ImageRendered)image;
        Graphics2D graphics2D = java2DRenderingContext.getGraphics2D();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle.x, rectangle.y);
        double d = rectangle.getWidth() / (double)imageInfo.getSize().getWidthMpt();
        double d2 = rectangle.getHeight() / (double)imageInfo.getSize().getHeightMpt();
        float f = 72.0f;
        affineTransform.scale(d *= (double)(f *= 1000.0f) / imageInfo.getSize().getDpiHorizontal(), d2 *= (double)f / imageInfo.getSize().getDpiVertical());
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        if (imageRendered.getTransparentColor() != null && !renderedImage.getColorModel().hasAlpha()) {
            int n = imageRendered.getTransparentColor().getRGB();
            BufferedImage bufferedImage = this.makeTransparentImage(renderedImage);
            WritableRaster writableRaster = bufferedImage.getAlphaRaster();
            int[] nArray = new int[]{0};
            int n2 = bufferedImage.getHeight();
            for (int i = 0; i < n2; ++i) {
                int n3 = bufferedImage.getWidth();
                for (int j = 0; j < n3; ++j) {
                    int n4 = bufferedImage.getRGB(j, i);
                    if (n4 != n) continue;
                    writableRaster.setPixel(j, i, nArray);
                }
            }
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        } else {
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
    }

    private BufferedImage makeTransparentImage(RenderedImage renderedImage) {
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawRenderedImage(renderedImage, new AffineTransform());
        graphics2D.dispose();
        return bufferedImage;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof ImageRendered) && renderingContext instanceof Java2DRenderingContext;
    }
}

