/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Stack;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.java2d.Java2DBorderPainter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRenderingContext;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.w3c.dom.Document;

public class Java2DPainter
extends AbstractIFPainter {
    protected IFContext ifContext;
    protected FontInfo fontInfo;
    private Java2DBorderPainter borderPainter;
    protected Java2DGraphicsState g2dState;
    private Stack g2dStateStack = new Stack();

    public Java2DPainter(Graphics2D graphics2D, IFContext iFContext, FontInfo fontInfo) {
        this(graphics2D, iFContext, fontInfo, null);
    }

    public Java2DPainter(Graphics2D graphics2D, IFContext iFContext, FontInfo fontInfo, IFState iFState) {
        this.ifContext = iFContext;
        this.state = iFState != null ? iFState.push() : IFState.create();
        this.fontInfo = fontInfo;
        this.g2dState = new Java2DGraphicsState(graphics2D, fontInfo, graphics2D.getTransform());
        this.borderPainter = new Java2DBorderPainter(this);
    }

    public IFContext getContext() {
        return this.ifContext;
    }

    protected FontInfo getFontInfo() {
        return this.fontInfo;
    }

    protected Java2DGraphicsState getState() {
        return this.g2dState;
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(affineTransform);
            this.clipRect(rectangle);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startViewport()", iOException);
        }
    }

    public void endViewport() throws IFException {
        this.restoreGraphicsState();
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        this.saveGraphicsState();
        try {
            this.concatenateTransformationMatrix(affineTransform);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startGroup()", iOException);
        }
    }

    public void endGroup() throws IFException {
        this.restoreGraphicsState();
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        this.drawImageUsingURI(string, rectangle);
    }

    protected RenderingContext createRenderingContext() {
        Java2DRenderingContext java2DRenderingContext = new Java2DRenderingContext(this.getUserAgent(), this.g2dState.getGraph(), this.getFontInfo());
        return java2DRenderingContext;
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        this.drawImageUsingDocument(document, rectangle);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
        this.getState().updateClip(rectangle);
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            this.g2dState.updatePaint(paint);
            this.g2dState.getGraph().fill(rectangle);
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            try {
                this.borderPainter.drawBorders(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unexpected I/O error");
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        this.borderPainter.drawLine(point, point2, n, color, ruleStyle);
    }

    public void drawText(int n, int n2, int n3, int n4, int[][] nArray, String string) throws IFException {
        int n5;
        this.g2dState.updateColor(this.state.getTextColor());
        FontTriplet fontTriplet = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
        Font font = this.getFontInfo().getFontInstance(fontTriplet, this.state.getFontSize());
        this.g2dState.updateFont(font.getFontName(), this.state.getFontSize() * 1000);
        Graphics2D graphics2D = this.g2dState.getGraph();
        GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(graphics2D.getFontRenderContext(), string);
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        int n6 = string.length();
        int[] nArray2 = IFUtil.convertDPToDX(nArray);
        int n7 = n5 = nArray2 != null ? nArray2.length : 0;
        if (nArray2 != null && n5 > 0 && nArray2[0] != 0) {
            ((Point2D)float_).setLocation(((Point2D)float_).getX() - (double)((float)nArray2[0] / 10.0f), ((Point2D)float_).getY());
            glyphVector.setGlyphPosition(0, float_);
        }
        for (int i = 0; i < n6; ++i) {
            char c = string.charAt(i);
            float f = 0.0f;
            int n8 = font.getCharWidth(c);
            if (n4 != 0 && CharUtilities.isAdjustableSpace(c)) {
                f += (float)n4;
            }
            f += (float)n3;
            if (nArray2 != null && i < n5 - 1) {
                f += (float)nArray2[i + 1];
            }
            ((Point2D)float_).setLocation(((Point2D)float_).getX() + (double)n8 + (double)f, ((Point2D)float_).getY());
            glyphVector.setGlyphPosition(i + 1, float_);
        }
        graphics2D.drawGlyphVector(glyphVector, n, n2);
    }

    protected void saveGraphicsState() {
        this.g2dStateStack.push(this.g2dState);
        this.g2dState = new Java2DGraphicsState(this.g2dState);
    }

    protected void restoreGraphicsState() {
        this.g2dState.dispose();
        this.g2dState = (Java2DGraphicsState)this.g2dStateStack.pop();
    }

    private void concatenateTransformationMatrix(AffineTransform affineTransform) throws IOException {
        this.g2dState.transform(affineTransform);
    }
}

