/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.util.bitmap.BitmapImageUtil;
import org.apache.fop.util.bitmap.DitherUtil;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLGenerator {
    private static final String US_ASCII = "US-ASCII";
    private static final String ISO_8859_1 = "ISO-8859-1";
    public static final char ESC = '\u001b';
    public static final int[] PCL_RESOLUTIONS = new int[]{75, 100, 150, 200, 300, 600};
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
    private final DecimalFormat df2 = new DecimalFormat("0.##", this.symbols);
    private final DecimalFormat df4 = new DecimalFormat("0.####", this.symbols);
    private final OutputStream out;
    private boolean currentSourceTransparency = true;
    private boolean currentPatternTransparency = true;
    private int maxBitmapResolution = PCL_RESOLUTIONS[PCL_RESOLUTIONS.length - 1];
    private float ditheringQuality = 0.5f;
    private final boolean usePCLShades = false;
    private static int jaiAvailable = -1;
    private static final byte[] THRESHOLD_TABLE = new byte[256];

    public PCLGenerator(OutputStream outputStream) {
        this.out = outputStream;
    }

    public PCLGenerator(OutputStream outputStream, int n) {
        this(outputStream);
        boolean bl = false;
        for (int i = 0; i < PCL_RESOLUTIONS.length; ++i) {
            if (PCL_RESOLUTIONS[i] != n) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("Illegal value for maximum resolution!");
        }
        this.maxBitmapResolution = n;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public String getTextEncoding() {
        return ISO_8859_1;
    }

    public int getMaximumBitmapResolution() {
        return this.maxBitmapResolution;
    }

    public void writeCommand(String string) throws IOException {
        this.out.write(27);
        this.out.write(string.getBytes(US_ASCII));
    }

    public void writeText(String string) throws IOException {
        this.out.write(string.getBytes(ISO_8859_1));
    }

    public final String formatDouble2(double d) {
        return this.df2.format(d);
    }

    public final String formatDouble4(double d) {
        return this.df4.format(d);
    }

    public void universalEndOfLanguage() throws IOException {
        this.writeCommand("%-12345X");
    }

    public void resetPrinter() throws IOException {
        this.writeCommand("E");
    }

    public void separateJobs() throws IOException {
        this.writeCommand("&l1T");
    }

    public void formFeed() throws IOException {
        this.out.write(12);
    }

    public void setUnitOfMeasure(int n) throws IOException {
        this.writeCommand("&u" + n + "D");
    }

    public void setRasterGraphicsResolution(int n) throws IOException {
        this.writeCommand("*t" + n + "R");
    }

    public void selectPageSize(int n) throws IOException {
        this.writeCommand("&l" + n + "A");
    }

    public void selectPaperSource(int n) throws IOException {
        this.writeCommand("&l" + n + "H");
    }

    public void selectOutputBin(int n) throws IOException {
        this.writeCommand("&l" + n + "G");
    }

    public void selectDuplexMode(int n) throws IOException {
        this.writeCommand("&l" + n + "S");
    }

    public void clearHorizontalMargins() throws IOException {
        this.writeCommand("9");
    }

    public void setTopMargin(int n) throws IOException {
        this.writeCommand("&l" + n + "E");
    }

    public void setTextLength(int n) throws IOException {
        this.writeCommand("&l" + n + "F");
    }

    public void setVMI(double d) throws IOException {
        this.writeCommand("&l" + this.formatDouble4(d) + "C");
    }

    public void setCursorPos(double d, double d2) throws IOException {
        if (d < 0.0) {
            this.writeCommand("&a0h" + this.formatDouble2(d / 100.0) + "h" + this.formatDouble2(d2 / 100.0) + "V");
        } else {
            this.writeCommand("&a" + this.formatDouble2(d / 100.0) + "h" + this.formatDouble2(d2 / 100.0) + "V");
        }
    }

    public void pushCursorPos() throws IOException {
        this.writeCommand("&f0S");
    }

    public void popCursorPos() throws IOException {
        this.writeCommand("&f1S");
    }

    public void changePrintDirection(int n) throws IOException {
        this.writeCommand("&a" + n + "P");
    }

    public void enterHPGL2Mode(boolean bl) throws IOException {
        if (bl) {
            this.writeCommand("%0B");
        } else {
            this.writeCommand("%1B");
        }
    }

    public void enterPCLMode(boolean bl) throws IOException {
        if (bl) {
            this.writeCommand("%0A");
        } else {
            this.writeCommand("%1A");
        }
    }

    protected void fillRect(int n, int n2, Color color) throws IOException {
        if (n == 0 || n2 == 0) {
            return;
        }
        if (n2 < 0) {
            n2 *= -1;
        }
        this.setPatternTransparencyMode(false);
        if (Color.black.equals(color) || Color.white.equals(color)) {
            this.writeCommand("*c" + this.formatDouble4((double)n / 100.0) + "h" + this.formatDouble4((double)n2 / 100.0) + "V");
            int n3 = this.convertToPCLShade(color);
            this.writeCommand("*c" + n3 + "G");
            this.writeCommand("*c2P");
        } else {
            this.defineGrayscalePattern(color, 32, 4);
            this.writeCommand("*c" + this.formatDouble4((double)n / 100.0) + "h" + this.formatDouble4((double)n2 / 100.0) + "V");
            this.writeCommand("*c32G");
            this.writeCommand("*c4P");
        }
        this.setPatternTransparencyMode(true);
    }

    public void defineGrayscalePattern(Color color, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(8);
        int n3 = this.convertToGray(color.getRed(), color.getGreen(), color.getBlue());
        byte[] byArray = n2 == 8 ? DitherUtil.getBayerDither(8, n3, false) : DitherUtil.getBayerDither(4, n3, true);
        dataOutputStream.write(byArray);
        if (byteArrayOutputStream.size() % 2 > 0) {
            byteArrayOutputStream.write(0);
        }
        this.writeCommand("*c" + n + "G");
        this.writeCommand("*c" + byteArrayOutputStream.size() + "W");
        byteArrayOutputStream.writeTo(this.out);
        this.writeCommand("*c4Q");
    }

    public void setSourceTransparencyMode(boolean bl) throws IOException {
        this.setTransparencyMode(bl, this.currentPatternTransparency);
    }

    public void setPatternTransparencyMode(boolean bl) throws IOException {
        this.setTransparencyMode(this.currentSourceTransparency, bl);
    }

    public void setTransparencyMode(boolean bl, boolean bl2) throws IOException {
        if (bl != this.currentSourceTransparency && bl2 != this.currentPatternTransparency) {
            this.writeCommand("*v" + (bl ? (char)'0' : '1') + "n" + (bl2 ? (char)'0' : '1') + "O");
        } else if (bl != this.currentSourceTransparency) {
            this.writeCommand("*v" + (bl ? (char)'0' : '1') + "N");
        } else if (bl2 != this.currentPatternTransparency) {
            this.writeCommand("*v" + (bl2 ? (char)'0' : '1') + "O");
        }
        this.currentSourceTransparency = bl;
        this.currentPatternTransparency = bl2;
    }

    public final int convertToGray(int n, int n2, int n3) {
        return BitmapImageUtil.convertToGray(n, n2, n3);
    }

    public final int convertToPCLShade(Color color) {
        float f = (float)this.convertToGray(color.getRed(), color.getGreen(), color.getBlue()) / 255.0f;
        return (int)(100.0f - f * 100.0f);
    }

    public void selectGrayscale(Color color) throws IOException {
        if (Color.black.equals(color)) {
            this.selectCurrentPattern(0, 0);
        } else if (Color.white.equals(color)) {
            this.selectCurrentPattern(0, 1);
        } else {
            this.defineGrayscalePattern(color, 32, 4);
            this.selectCurrentPattern(32, 4);
        }
    }

    public void selectCurrentPattern(int n, int n2) throws IOException {
        if (n2 > 1) {
            this.writeCommand("*c" + n + "G");
        }
        this.writeCommand("*v" + n2 + "T");
    }

    public void setDitheringQuality(float f) {
        this.ditheringQuality = f = Math.min(Math.max(0.0f, f), 1.0f);
    }

    public float getDitheringQuality() {
        return this.ditheringQuality;
    }

    public static boolean isMonochromeImage(RenderedImage renderedImage) {
        return BitmapImageUtil.isMonochromeImage(renderedImage);
    }

    public static boolean isGrayscaleImage(RenderedImage renderedImage) {
        return BitmapImageUtil.isGrayscaleImage(renderedImage);
    }

    public static boolean isJAIAvailable() {
        if (jaiAvailable < 0) {
            try {
                String string = "javax.media.jai.JAI";
                Class.forName(string);
                jaiAvailable = 1;
            }
            catch (ClassNotFoundException classNotFoundException) {
                jaiAvailable = 0;
            }
        }
        return jaiAvailable > 0;
    }

    private int calculatePCLResolution(int n) {
        return this.calculatePCLResolution(n, false);
    }

    private int calculatePCLResolution(int n, boolean bl) {
        int n2 = -1;
        for (int i = PCL_RESOLUTIONS.length - 2; i >= 0; --i) {
            if (n <= PCL_RESOLUTIONS[i]) continue;
            int n3 = i + 1;
            if (n3 < PCL_RESOLUTIONS.length - 2) {
                n3 += bl ? 2 : 0;
            } else if (n3 < PCL_RESOLUTIONS.length - 1) {
                n3 += bl ? 1 : 0;
            }
            n2 = n3;
            break;
        }
        if (n2 < 0) {
            int n4 = n2 = bl ? 2 : 0;
        }
        while (n2 > 0 && PCL_RESOLUTIONS[n2] > this.getMaximumBitmapResolution()) {
            --n2;
        }
        return PCL_RESOLUTIONS[n2];
    }

    private boolean isValidPCLResolution(int n) {
        return n == this.calculatePCLResolution(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage getMask(RenderedImage renderedImage, Dimension dimension) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel.hasAlpha()) {
            BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 10);
            Raster raster = renderedImage.getData();
            GraphicsUtil.copyBand((Raster)raster, (int)colorModel.getNumColorComponents(), (WritableRaster)bufferedImage.getRaster(), (int)0);
            LookupOp lookupOp = new LookupOp(new ByteLookupTable(0, THRESHOLD_TABLE), null);
            BufferedImage bufferedImage2 = lookupOp.filter(bufferedImage, null);
            BufferedImage bufferedImage3 = new BufferedImage(dimension.width, dimension.height, 12);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            try {
                AffineTransform affineTransform = new AffineTransform();
                double d = dimension.getWidth() / (double)renderedImage.getWidth();
                double d2 = dimension.getHeight() / (double)renderedImage.getHeight();
                affineTransform.scale(d, d2);
                graphics2D.drawRenderedImage(bufferedImage2, affineTransform);
            }
            finally {
                graphics2D.dispose();
            }
            return bufferedImage3;
        }
        return null;
    }

    public void paintBitmap(RenderedImage renderedImage, Dimension dimension, boolean bl) throws IOException {
        double d = (double)renderedImage.getWidth() / UnitConv.mpt2in((double)dimension.width);
        double d2 = (double)renderedImage.getHeight() / UnitConv.mpt2in((double)dimension.height);
        double d3 = Math.max(d, d2);
        int n = (int)Math.round(d3);
        int n2 = this.calculatePCLResolution(n, true);
        Dimension dimension2 = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        Dimension dimension3 = d3 == (double)n2 ? dimension2 : new Dimension((int)Math.ceil(UnitConv.mpt2px((double)dimension.width, (int)n2)), (int)Math.ceil(UnitConv.mpt2px((double)dimension.height, (int)n2)));
        boolean bl2 = !dimension2.equals(dimension3);
        boolean bl3 = PCLGenerator.isMonochromeImage(renderedImage);
        if (!bl3) {
            RenderedImage renderedImage2 = null;
            if (renderedImage2 != null) {
                this.pushCursorPos();
                this.selectCurrentPattern(0, 1);
                this.setTransparencyMode(true, true);
                this.paintMonochromeBitmap(renderedImage2, n2);
                this.popCursorPos();
            }
            RenderedImage renderedImage3 = BitmapImageUtil.convertToMonochrome(renderedImage, dimension3, this.ditheringQuality);
            this.selectCurrentPattern(0, 0);
            this.setTransparencyMode(bl || renderedImage2 != null, true);
            this.paintMonochromeBitmap(renderedImage3, n2);
        } else {
            RenderedImage renderedImage4 = renderedImage;
            if (bl2) {
                renderedImage4 = BitmapImageUtil.convertToMonochrome(renderedImage, dimension3);
            }
            this.setSourceTransparencyMode(bl);
            this.selectCurrentPattern(0, 0);
            this.paintMonochromeBitmap(renderedImage4, n2);
        }
    }

    private int toGray(int n) {
        double d = 0.072169 * (double)(n & 0xFF);
        d += 0.71516 * (double)((n >>= 8) & 0xFF);
        return (int)(d += 0.212671 * (double)((n >>= 8) & 0xFF));
    }

    public void paintMonochromeBitmap(RenderedImage renderedImage, int n) throws IOException {
        if (!this.isValidPCLResolution(n)) {
            throw new IllegalArgumentException("Invalid PCL resolution: " + n);
        }
        boolean bl = PCLGenerator.isMonochromeImage(renderedImage);
        if (!bl) {
            throw new IllegalArgumentException("img must be a monochrome image");
        }
        this.setRasterGraphicsResolution(n);
        this.writeCommand("*r0f" + renderedImage.getHeight() + "t" + renderedImage.getWidth() + "s1A");
        Raster raster = renderedImage.getData();
        Encoder encoder = new Encoder(renderedImage);
        int n2 = renderedImage.getWidth();
        IndexColorModel indexColorModel = (IndexColorModel)renderedImage.getColorModel();
        if (indexColorModel.getTransferType() == 0) {
            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, renderedImage.getWidth(), renderedImage.getHeight(), 1);
            if (renderedImage.getSampleModel().equals(multiPixelPackedSampleModel) && dataBufferByte.getNumBanks() == 1) {
                int n3;
                byte[] byArray = dataBufferByte.getData();
                int n4 = multiPixelPackedSampleModel.getScanlineStride();
                int n5 = 0;
                int n6 = this.toGray(indexColorModel.getRGB(0));
                boolean bl2 = n6 > (n3 = this.toGray(indexColorModel.getRGB(1)));
                int n7 = renderedImage.getHeight();
                for (int i = 0; i < n7; ++i) {
                    int n8 = n4;
                    for (int j = 0; j < n8; ++j) {
                        if (bl2) {
                            encoder.add8Bits(byArray[n5]);
                        } else {
                            encoder.add8Bits(~byArray[n5]);
                        }
                        ++n5;
                    }
                    encoder.endLine();
                }
            } else {
                int n9 = renderedImage.getHeight();
                for (int i = 0; i < n9; ++i) {
                    byte[] byArray = (byte[])raster.getDataElements(0, i, n2, 1, null);
                    int n10 = n2;
                    for (int j = 0; j < n10; ++j) {
                        encoder.addBit(byArray[j] == 0);
                    }
                    encoder.endLine();
                }
            }
        } else {
            int n11 = renderedImage.getHeight();
            for (int i = 0; i < n11; ++i) {
                int n12 = n2;
                for (int j = 0; j < n12; ++j) {
                    int n13 = raster.getSample(j, i, 0);
                    encoder.addBit(n13 == 0);
                }
                encoder.endLine();
            }
        }
        this.writeCommand("*rB");
    }

    static {
        for (int i = 0; i < 256; ++i) {
            PCLGenerator.THRESHOLD_TABLE[i] = (byte)(i < 240 ? 255 : 0);
        }
    }

    private class Encoder {
        private int imgw;
        private int bytewidth;
        private byte[] rle;
        private byte[] uncompressed;
        private int lastcount = -1;
        private byte lastbyte = 0;
        private int rlewidth = 0;
        private byte ib = 0;
        private int x = 0;
        private boolean zeroRow = true;

        public Encoder(RenderedImage renderedImage) {
            this.imgw = renderedImage.getWidth();
            this.bytewidth = this.imgw / 8;
            if (this.imgw % 8 != 0) {
                ++this.bytewidth;
            }
            this.rle = new byte[this.bytewidth * 2];
            this.uncompressed = new byte[this.bytewidth];
        }

        public void addBit(boolean bl) {
            if (bl) {
                this.ib = (byte)(this.ib | 1);
            }
            if (this.x % 8 == 7 || this.x + 1 == this.imgw) {
                this.finishedByte();
            } else {
                this.ib = (byte)(this.ib << 1);
            }
            ++this.x;
        }

        public void add8Bits(byte by) {
            this.ib = by;
            this.finishedByte();
            this.x += 8;
        }

        private void finishedByte() {
            if (this.rlewidth < this.bytewidth) {
                if (this.lastcount >= 0) {
                    if (this.ib == this.lastbyte) {
                        ++this.lastcount;
                    } else {
                        this.rle[this.rlewidth++] = (byte)(this.lastcount & 0xFF);
                        this.rle[this.rlewidth++] = this.lastbyte;
                        this.lastbyte = this.ib;
                        this.lastcount = 0;
                    }
                } else {
                    this.lastbyte = this.ib;
                    this.lastcount = 0;
                }
                if (this.lastcount == 255 || this.x + 1 == this.imgw) {
                    this.rle[this.rlewidth++] = (byte)(this.lastcount & 0xFF);
                    this.rle[this.rlewidth++] = this.lastbyte;
                    this.lastbyte = 0;
                    this.lastcount = -1;
                }
            }
            this.uncompressed[this.x / 8] = this.ib;
            if (this.ib != 0) {
                this.zeroRow = false;
            }
            this.ib = 0;
        }

        public void endLine() throws IOException {
            if (this.zeroRow && PCLGenerator.this.currentSourceTransparency) {
                PCLGenerator.this.writeCommand("*b1Y");
            } else if (this.rlewidth < this.bytewidth) {
                PCLGenerator.this.writeCommand("*b1m" + this.rlewidth + "W");
                PCLGenerator.this.out.write(this.rle, 0, this.rlewidth);
            } else {
                PCLGenerator.this.writeCommand("*b0m" + this.bytewidth + "W");
                PCLGenerator.this.out.write(this.uncompressed);
            }
            this.lastcount = -1;
            this.rlewidth = 0;
            this.ib = 0;
            this.x = 0;
            this.zeroRow = true;
        }
    }
}

