/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.util.UnitConv;

public class PCLPageDefinition {
    private static List pageDefinitions;
    private static PCLPageDefinition defaultPageDefinition;
    private final String name;
    private final int selector;
    private final Dimension physicalPageSize;
    private final Rectangle logicalPageRect;
    private final boolean landscape;

    public PCLPageDefinition(String string, int n, Dimension dimension, Rectangle rectangle, boolean bl) {
        this.name = string;
        this.selector = n;
        this.physicalPageSize = dimension;
        this.logicalPageRect = rectangle;
        this.landscape = bl;
    }

    public String getName() {
        return this.name;
    }

    public int getSelector() {
        return this.selector;
    }

    public boolean isLandscapeFormat() {
        return this.landscape;
    }

    public Dimension getPhysicalPageSize() {
        return this.physicalPageSize;
    }

    public Rectangle getLogicalPageRect() {
        return this.logicalPageRect;
    }

    private boolean matches(long l, long l2, int n) {
        return Math.abs((long)this.physicalPageSize.width - l) < (long)n && Math.abs((long)this.physicalPageSize.height - l2) < (long)n;
    }

    public String toString() {
        return this.getName();
    }

    public static PCLPageDefinition getPageDefinition(long l, long l2, int n) {
        for (PCLPageDefinition pCLPageDefinition : pageDefinitions) {
            if (!pCLPageDefinition.matches(l, l2, n)) continue;
            return pCLPageDefinition;
        }
        return null;
    }

    public static PCLPageDefinition getPageDefinition(String string) {
        for (PCLPageDefinition pCLPageDefinition : pageDefinitions) {
            if (!pCLPageDefinition.getName().equalsIgnoreCase(string)) continue;
            return pCLPageDefinition;
        }
        return null;
    }

    public static PCLPageDefinition getDefaultPageDefinition() {
        return defaultPageDefinition;
    }

    private static int convert300dpiDotsToMpt(int n) {
        return (int)Math.round((double)n * 72000.0 / 300.0);
    }

    private static Dimension createPhysicalPageSizeInch(float f, float f2) {
        return new Dimension((int)Math.round(UnitConv.in2mpt((double)f)), (int)Math.round(UnitConv.in2mpt((double)f2)));
    }

    private static Dimension createPhysicalPageSizeMm(float f, float f2) {
        return new Dimension((int)Math.round(UnitConv.mm2mpt((double)f)), (int)Math.round(UnitConv.mm2mpt((double)f2)));
    }

    private static Rectangle createLogicalPageRect(int n, int n2, int n3, int n4) {
        return new Rectangle(PCLPageDefinition.convert300dpiDotsToMpt(n), PCLPageDefinition.convert300dpiDotsToMpt(n2), PCLPageDefinition.convert300dpiDotsToMpt(n3), PCLPageDefinition.convert300dpiDotsToMpt(n4));
    }

    private static void createPageDefinitions() {
        pageDefinitions = new ArrayList();
        pageDefinitions.add(new PCLPageDefinition("Letter", 2, PCLPageDefinition.createPhysicalPageSizeInch(8.5f, 11.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 2400, 3300), false));
        defaultPageDefinition = new PCLPageDefinition("Legal", 3, PCLPageDefinition.createPhysicalPageSizeInch(8.5f, 14.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 2400, 4200), false);
        pageDefinitions.add(defaultPageDefinition);
        pageDefinitions.add(new PCLPageDefinition("Executive", 1, PCLPageDefinition.createPhysicalPageSizeInch(7.25f, 10.5f), PCLPageDefinition.createLogicalPageRect(75, 0, 2025, 3150), false));
        pageDefinitions.add(new PCLPageDefinition("Ledger", 6, PCLPageDefinition.createPhysicalPageSizeInch(11.0f, 17.0f), PCLPageDefinition.createLogicalPageRect(75, 0, 3150, 5100), false));
        pageDefinitions.add(new PCLPageDefinition("A5", 25, PCLPageDefinition.createPhysicalPageSizeMm(148.0f, 210.0f), PCLPageDefinition.createLogicalPageRect(71, 0, 1745, 2480), false));
        pageDefinitions.add(new PCLPageDefinition("A4", 26, PCLPageDefinition.createPhysicalPageSizeMm(210.0f, 297.0f), PCLPageDefinition.createLogicalPageRect(71, 0, 2338, 3507), false));
        pageDefinitions.add(new PCLPageDefinition("A3", 27, PCLPageDefinition.createPhysicalPageSizeMm(297.0f, 420.0f), PCLPageDefinition.createLogicalPageRect(71, 0, 3365, 4960), false));
        pageDefinitions.add(new PCLPageDefinition("LetterL", 2, PCLPageDefinition.createPhysicalPageSizeInch(11.0f, 8.5f), PCLPageDefinition.createLogicalPageRect(60, 0, 3180, 2550), true));
        pageDefinitions.add(new PCLPageDefinition("LegalL", 3, PCLPageDefinition.createPhysicalPageSizeInch(14.0f, 8.5f), PCLPageDefinition.createLogicalPageRect(60, 0, 4080, 2550), true));
        pageDefinitions.add(new PCLPageDefinition("ExecutiveL", 1, PCLPageDefinition.createPhysicalPageSizeInch(10.5f, 7.25f), PCLPageDefinition.createLogicalPageRect(60, 0, 3030, 2175), true));
        pageDefinitions.add(new PCLPageDefinition("LedgerL", 6, PCLPageDefinition.createPhysicalPageSizeInch(17.0f, 11.0f), PCLPageDefinition.createLogicalPageRect(60, 0, 4980, 3300), true));
        pageDefinitions.add(new PCLPageDefinition("A5L", 25, PCLPageDefinition.createPhysicalPageSizeMm(210.0f, 148.0f), PCLPageDefinition.createLogicalPageRect(59, 0, 2362, 1747), true));
        pageDefinitions.add(new PCLPageDefinition("A4L", 26, PCLPageDefinition.createPhysicalPageSizeMm(297.0f, 210.0f), PCLPageDefinition.createLogicalPageRect(59, 0, 3389, 2480), true));
        pageDefinitions.add(new PCLPageDefinition("A3L", 27, PCLPageDefinition.createPhysicalPageSizeMm(420.0f, 297.0f), PCLPageDefinition.createLogicalPageRect(59, 0, 4842, 3507), true));
    }

    static {
        PCLPageDefinition.createPageDefinitions();
    }
}

