/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.IndexColorModel;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFReference;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public abstract class AbstractImageAdapter
implements PDFImage {
    private static Log log = LogFactory.getLog(AbstractImageAdapter.class);
    private String key;
    protected Image image;
    private PDFICCStream pdfICCStream;
    private static final int MAX_HIVAL = 255;
    private boolean multipleFiltersAllowed = true;

    public AbstractImageAdapter(Image image, String string) {
        this.image = image;
        this.key = string;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New ImageAdapter created for key: " + string));
        }
    }

    public String getKey() {
        return this.key;
    }

    protected ColorSpace getImageColorSpace() {
        return this.image.getColorSpace();
    }

    public void setup(PDFDocument pDFDocument) {
        ICC_Profile iCC_Profile = this.getEffectiveICCProfile();
        PDFDeviceColorSpace pDFDeviceColorSpace = AbstractImageAdapter.toPDFColorSpace(this.getImageColorSpace());
        if (iCC_Profile != null) {
            this.pdfICCStream = AbstractImageAdapter.setupColorProfile(pDFDocument, iCC_Profile, pDFDeviceColorSpace);
        }
        if (pDFDocument.getProfile().getPDFAMode().isPDFA1LevelB() && pDFDeviceColorSpace != null && pDFDeviceColorSpace.getColorSpace() != 2 && pDFDeviceColorSpace.getColorSpace() != 1 && iCC_Profile == null) {
            throw new PDFConformanceException("PDF/A-1 does not allow mixing DeviceRGB and DeviceCMYK: " + this.image.getInfo());
        }
    }

    protected ICC_Profile getEffectiveICCProfile() {
        return this.image.getICCProfile();
    }

    private static PDFICCStream setupColorProfile(PDFDocument pDFDocument, ICC_Profile iCC_Profile, PDFDeviceColorSpace pDFDeviceColorSpace) {
        PDFICCStream pDFICCStream;
        boolean bl = ColorProfileUtil.isDefaultsRGB((ICC_Profile)iCC_Profile);
        String string = ColorProfileUtil.getICCProfileDescription((ICC_Profile)iCC_Profile);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Image returns ICC profile: " + string + ", default sRGB=" + bl));
        }
        PDFICCBasedColorSpace pDFICCBasedColorSpace = pDFDocument.getResources().getICCColorSpaceByProfileName(string);
        if (!bl) {
            if (pDFICCBasedColorSpace == null) {
                pDFICCStream = pDFDocument.getFactory().makePDFICCStream();
                pDFICCStream.setColorSpace(iCC_Profile, pDFDeviceColorSpace);
                pDFICCBasedColorSpace = pDFDocument.getFactory().makeICCBasedColorSpace(null, null, pDFICCStream);
            } else {
                pDFICCStream = pDFICCBasedColorSpace.getICCStream();
            }
        } else {
            if (pDFICCBasedColorSpace == null) {
                if (string == null || !string.startsWith("sRGB")) {
                    log.warn((Object)("The default sRGB profile was indicated, but the profile description does not match what was expected: " + string));
                }
                pDFICCBasedColorSpace = (PDFICCBasedColorSpace)pDFDocument.getResources().getColorSpace(new PDFName("DefaultRGB"));
            }
            if (pDFICCBasedColorSpace == null) {
                pDFICCBasedColorSpace = PDFICCBasedColorSpace.setupsRGBColorSpace(pDFDocument);
            }
            pDFICCStream = pDFICCBasedColorSpace.getICCStream();
        }
        return pDFICCStream;
    }

    public int getWidth() {
        return this.image.getSize().getWidthPx();
    }

    public int getHeight() {
        return this.image.getSize().getHeightPx();
    }

    public boolean isTransparent() {
        return false;
    }

    public PDFColor getTransparentColor() {
        return null;
    }

    public String getMask() {
        return null;
    }

    public String getSoftMask() {
        return null;
    }

    public PDFReference getSoftMaskReference() {
        return null;
    }

    public boolean isInverted() {
        return false;
    }

    public boolean isPS() {
        return false;
    }

    public PDFICCStream getICCStream() {
        return this.pdfICCStream;
    }

    public void populateXObjectDictionary(PDFDictionary pDFDictionary) {
    }

    protected void populateXObjectDictionaryForIndexColorModel(PDFDictionary pDFDictionary, IndexColorModel indexColorModel) {
        PDFArray pDFArray = new PDFArray(pDFDictionary);
        pDFArray.add(new PDFName("Indexed"));
        if (indexColorModel.getColorSpace().getType() != 5) {
            log.warn((Object)("Indexed color space is not using RGB as base color space. The image may not be handled correctly. Base color space: " + indexColorModel.getColorSpace() + " Image: " + this.image.getInfo()));
        }
        pDFArray.add(new PDFName(AbstractImageAdapter.toPDFColorSpace(indexColorModel.getColorSpace()).getName()));
        int n = indexColorModel.getMapSize();
        int n2 = n - 1;
        if (n2 > 255) {
            throw new UnsupportedOperationException("hival must not go beyond 255");
        }
        pDFArray.add((Object)n2);
        int[] nArray = new int[n];
        indexColorModel.getRGBs(nArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            byteArrayOutputStream.write((n3 & 0xFF0000) >> 16);
            byteArrayOutputStream.write((n3 & 0xFF00) >> 8);
            byteArrayOutputStream.write(n3 & 0xFF);
        }
        pDFArray.add(byteArrayOutputStream.toByteArray());
        pDFDictionary.put("ColorSpace", pDFArray);
        pDFDictionary.put("BitsPerComponent", indexColorModel.getPixelSize());
        Integer n4 = AbstractImageAdapter.getIndexOfFirstTransparentColorInPalette(indexColorModel);
        if (n4 != null) {
            PDFArray pDFArray2 = new PDFArray(pDFDictionary);
            pDFArray2.add(n4);
            pDFArray2.add(n4);
            pDFDictionary.put("Mask", pDFArray2);
        }
    }

    private static Integer getIndexOfFirstTransparentColorInPalette(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        byte[] byArray2 = new byte[indexColorModel.getMapSize()];
        byte[] byArray3 = new byte[indexColorModel.getMapSize()];
        byte[] byArray4 = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        indexColorModel.getReds(byArray2);
        indexColorModel.getGreens(byArray3);
        indexColorModel.getBlues(byArray4);
        for (int i = 0; i < indexColorModel.getMapSize(); ++i) {
            if ((byArray[i] & 0xFF) != 0) continue;
            return i;
        }
        return null;
    }

    public static PDFDeviceColorSpace toPDFColorSpace(ColorSpace colorSpace) {
        if (colorSpace == null) {
            return null;
        }
        PDFDeviceColorSpace pDFDeviceColorSpace = new PDFDeviceColorSpace(0);
        switch (colorSpace.getType()) {
            case 9: {
                pDFDeviceColorSpace.setColorSpace(3);
                break;
            }
            case 6: {
                pDFDeviceColorSpace.setColorSpace(1);
                break;
            }
            default: {
                pDFDeviceColorSpace.setColorSpace(2);
            }
        }
        return pDFDeviceColorSpace;
    }

    public boolean multipleFiltersAllowed() {
        return this.multipleFiltersAllowed;
    }

    public void disallowMultipleFilters() {
        this.multipleFiltersAllowed = false;
    }
}

