/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.AlphaRasterImage;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;

public class ImageRenderedAdapter
extends AbstractImageAdapter {
    private static Log log = LogFactory.getLog(ImageRenderedAdapter.class);
    private ImageEncodingHelper encodingHelper;
    private PDFFilter pdfFilter = null;
    private String maskRef;
    private PDFReference softMask;

    public ImageRenderedAdapter(ImageRendered imageRendered, String string) {
        super((Image)imageRendered, string);
        this.encodingHelper = new ImageEncodingHelper(imageRendered.getRenderedImage(), true);
    }

    public ImageRendered getImage() {
        return (ImageRendered)this.image;
    }

    public int getWidth() {
        RenderedImage renderedImage = this.getImage().getRenderedImage();
        return renderedImage.getWidth();
    }

    public int getHeight() {
        RenderedImage renderedImage = this.getImage().getRenderedImage();
        return renderedImage.getHeight();
    }

    private ColorModel getEffectiveColorModel() {
        return this.encodingHelper.getEncodedColorModel();
    }

    protected ColorSpace getImageColorSpace() {
        return this.getEffectiveColorModel().getColorSpace();
    }

    protected ICC_Profile getEffectiveICCProfile() {
        ColorSpace colorSpace = this.getImageColorSpace();
        if (colorSpace instanceof ICC_ColorSpace) {
            ICC_ColorSpace iCC_ColorSpace = (ICC_ColorSpace)colorSpace;
            return iCC_ColorSpace.getProfile();
        }
        return null;
    }

    public void setup(PDFDocument pDFDocument) {
        RenderedImage renderedImage = this.getImage().getRenderedImage();
        super.setup(pDFDocument);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel.hasAlpha() && colorModel.getTransparency() == 3) {
            pDFDocument.getProfile().verifyTransparencyAllowed(this.image.getInfo().getOriginalURI());
            AlphaRasterImage alphaRasterImage = new AlphaRasterImage("Mask:" + this.getKey(), renderedImage);
            this.softMask = pDFDocument.addImage(null, alphaRasterImage).makeReference();
        }
    }

    public PDFDeviceColorSpace getColorSpace() {
        return ImageRenderedAdapter.toPDFColorSpace(this.getEffectiveColorModel().getColorSpace());
    }

    public int getBitsPerComponent() {
        ColorModel colorModel = this.getEffectiveColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            return indexColorModel.getComponentSize(0);
        }
        return colorModel.getComponentSize(0);
    }

    public boolean isTransparent() {
        ColorModel colorModel = this.getEffectiveColorModel();
        if (colorModel instanceof IndexColorModel && colorModel.getTransparency() == 3) {
            return true;
        }
        return this.getImage().getTransparentColor() != null;
    }

    public PDFColor getTransparentColor() {
        ColorModel colorModel = this.getEffectiveColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            if (colorModel.getTransparency() == 3) {
                int n = indexColorModel.getTransparentPixel();
                return new PDFColor(indexColorModel.getRed(n), indexColorModel.getGreen(n), indexColorModel.getBlue(n));
            }
        }
        return new PDFColor(this.getImage().getTransparentColor());
    }

    public String getMask() {
        return this.maskRef;
    }

    public PDFReference getSoftMaskReference() {
        return this.softMask;
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    public void outputContents(OutputStream outputStream) throws IOException {
        long l = System.currentTimeMillis();
        this.encodingHelper.encode(outputStream);
        long l2 = System.currentTimeMillis() - l;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Image encoding took " + l2 + "ms"));
        }
    }

    public void populateXObjectDictionary(PDFDictionary pDFDictionary) {
        ColorModel colorModel = this.getEffectiveColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            super.populateXObjectDictionaryForIndexColorModel(pDFDictionary, indexColorModel);
        }
    }

    public String getFilterHint() {
        return "image";
    }
}

