/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.GoToXYAction;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.render.intermediate.extensions.URIAction;
import org.apache.fop.render.pdf.PDFDocumentHandler;

public class PDFDocumentNavigationHandler
implements IFDocumentNavigationHandler {
    private final PDFDocumentHandler documentHandler;
    private final Map incompleteActions = new HashMap();
    private final Map completeActions = new HashMap();

    public PDFDocumentNavigationHandler(PDFDocumentHandler pDFDocumentHandler) {
        this.documentHandler = pDFDocumentHandler;
    }

    PDFDocument getPDFDoc() {
        return this.documentHandler.pdfDoc;
    }

    public void renderNamedDestination(NamedDestination namedDestination) throws IFException {
        PDFAction pDFAction = this.getAction(namedDestination.getAction());
        this.getPDFDoc().getFactory().makeDestination(namedDestination.getName(), pDFAction.makeReference());
    }

    public void renderBookmarkTree(BookmarkTree bookmarkTree) throws IFException {
        for (Bookmark bookmark : bookmarkTree.getBookmarks()) {
            this.renderBookmark(bookmark, null);
        }
    }

    private void renderBookmark(Bookmark bookmark, PDFOutline pDFOutline) throws IFException {
        PDFAction pDFAction;
        if (pDFOutline == null) {
            pDFOutline = this.getPDFDoc().getOutlineRoot();
        }
        String string = (pDFAction = this.getAction(bookmark.getAction())) != null ? pDFAction.makeReference().toString() : null;
        PDFOutline pDFOutline2 = this.getPDFDoc().getFactory().makeOutline(pDFOutline, bookmark.getTitle(), string, bookmark.isShown());
        for (Bookmark bookmark2 : bookmark.getChildBookmarks()) {
            this.renderBookmark(bookmark2, pDFOutline2);
        }
    }

    public void renderLink(Link link) throws IFException {
        Rectangle rectangle = link.getTargetRect();
        int n = this.documentHandler.currentPageRef.getPageDimension().height;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.getMinX() / 1000.0, ((double)n - rectangle.getMinY() - rectangle.getHeight()) / 1000.0, rectangle.getWidth() / 1000.0, rectangle.getHeight() / 1000.0);
        PDFAction pDFAction = this.getAction(link.getAction());
        PDFLink pDFLink = this.getPDFDoc().getFactory().makeLink(double_, pDFAction);
        if (pDFLink != null) {
            PDFStructElem pDFStructElem = (PDFStructElem)link.getAction().getStructureTreeElement();
            if (this.documentHandler.getUserAgent().isAccessibilityEnabled() && pDFStructElem != null) {
                this.documentHandler.getLogicalStructureHandler().addLinkContentItem(pDFLink, pDFStructElem);
            }
            this.documentHandler.currentPage.addAnnotation(pDFLink);
        }
    }

    public void commit() {
    }

    public void addResolvedAction(AbstractAction abstractAction) throws IFException {
        assert (abstractAction.isComplete());
        PDFAction pDFAction = (PDFAction)this.incompleteActions.remove(abstractAction.getID());
        if (pDFAction == null) {
            this.getAction(abstractAction);
        } else if (pDFAction instanceof PDFGoTo) {
            PDFGoTo pDFGoTo = (PDFGoTo)pDFAction;
            this.updateTargetLocation(pDFGoTo, (GoToXYAction)abstractAction);
        } else {
            throw new UnsupportedOperationException("Action type not supported: " + pDFAction.getClass().getName());
        }
    }

    private PDFAction getAction(AbstractAction abstractAction) throws IFException {
        if (abstractAction == null) {
            return null;
        }
        PDFAction pDFAction = (PDFAction)this.completeActions.get(abstractAction.getID());
        if (pDFAction != null) {
            return pDFAction;
        }
        if (abstractAction instanceof GoToXYAction) {
            pDFAction = (PDFAction)this.incompleteActions.get(abstractAction.getID());
            if (pDFAction != null) {
                return pDFAction;
            }
            GoToXYAction goToXYAction = (GoToXYAction)abstractAction;
            PDFGoTo pDFGoTo = new PDFGoTo(null);
            this.getPDFDoc().assignObjectNumber(pDFGoTo);
            if (abstractAction.isComplete()) {
                this.updateTargetLocation(pDFGoTo, goToXYAction);
            } else {
                this.incompleteActions.put(abstractAction.getID(), pDFGoTo);
            }
            return pDFGoTo;
        }
        if (abstractAction instanceof URIAction) {
            URIAction uRIAction = (URIAction)abstractAction;
            assert (uRIAction.isComplete());
            String string = uRIAction.getURI();
            PDFFactory pDFFactory = this.getPDFDoc().getFactory();
            pDFAction = pDFFactory.getExternalAction(string, uRIAction.isNewWindow());
            if (!pDFAction.hasObjectNumber()) {
                this.getPDFDoc().registerObject(pDFAction);
            }
            this.completeActions.put(abstractAction.getID(), pDFAction);
            return pDFAction;
        }
        throw new UnsupportedOperationException("Unsupported action type: " + abstractAction + " (" + abstractAction.getClass().getName() + ")");
    }

    private void updateTargetLocation(PDFGoTo pDFGoTo, GoToXYAction goToXYAction) throws IFException {
        PDFDocumentHandler.PageReference pageReference = this.documentHandler.getPageReference(goToXYAction.getPageIndex());
        if (pageReference == null) {
            throw new IFException("Can't resolve page reference @ index: " + goToXYAction.getPageIndex(), null);
        }
        Point2D.Double double_ = null;
        double_ = new Point2D.Double((double)goToXYAction.getTargetLocation().x / 1000.0, (double)(pageReference.getPageDimension().height - goToXYAction.getTargetLocation().y) / 1000.0);
        String string = pageReference.getPageRef();
        pDFGoTo.setPageReference(string);
        pDFGoTo.setPosition(double_);
        this.getPDFDoc().addObject(pDFGoTo);
        this.completeActions.put(goToXYAction.getID(), pDFGoTo);
    }
}

