/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.pdf.PDFXMode;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.pdf.PDFDocumentHandler;
import org.apache.fop.render.pdf.PDFEventProducer;
import org.apache.fop.render.pdf.PDFRenderingUtil;
import org.apache.fop.util.LogUtil;

public class PDFRendererConfigurator
extends PrintRendererConfigurator {
    public PDFRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public void configure(Renderer renderer) {
        throw new UnsupportedOperationException();
    }

    private void configure(Configuration configuration, PDFRenderingUtil pDFRenderingUtil) throws FOPException {
        PDFEncryptionParams pDFEncryptionParams;
        Configuration configuration2;
        Object object;
        try {
            object = PDFRendererConfigurator.buildFilterMapFromConfiguration(configuration);
            if (object != null) {
                pDFRenderingUtil.setFilterMap((Map)object);
            }
        }
        catch (ConfigurationException configurationException) {
            LogUtil.handleException(log, (Exception)((Object)configurationException), false);
        }
        object = configuration.getChild("pdf-a-mode", true).getValue(null);
        if (object != null) {
            pDFRenderingUtil.setAMode(PDFAMode.valueOf((String)object));
        }
        if ((object = configuration.getChild("pdf-x-mode", true).getValue(null)) != null) {
            pDFRenderingUtil.setXMode(PDFXMode.valueOf((String)object));
        }
        if ((configuration2 = configuration.getChild("encryption-params", false)) != null) {
            Configuration configuration3;
            Configuration configuration4;
            Configuration configuration5;
            Configuration configuration6;
            Configuration configuration7;
            Configuration configuration8;
            Configuration configuration9;
            Configuration configuration10;
            String string;
            String string2;
            pDFEncryptionParams = pDFRenderingUtil.getEncryptionParams();
            Configuration configuration11 = configuration2.getChild("owner-password", false);
            if (configuration11 != null && (string2 = configuration11.getValue(null)) != null) {
                pDFEncryptionParams.setOwnerPassword(string2);
            }
            if ((string2 = configuration2.getChild("user-password", false)) != null && (string = string2.getValue(null)) != null) {
                pDFEncryptionParams.setUserPassword(string);
            }
            if ((string = configuration2.getChild("noprint", false)) != null) {
                pDFEncryptionParams.setAllowPrint(false);
            }
            if ((configuration10 = configuration2.getChild("nocopy", false)) != null) {
                pDFEncryptionParams.setAllowCopyContent(false);
            }
            if ((configuration9 = configuration2.getChild("noedit", false)) != null) {
                pDFEncryptionParams.setAllowEditContent(false);
            }
            if ((configuration8 = configuration2.getChild("noannotations", false)) != null) {
                pDFEncryptionParams.setAllowEditAnnotations(false);
            }
            if ((configuration7 = configuration2.getChild("nofillinforms", false)) != null) {
                pDFEncryptionParams.setAllowFillInForms(false);
            }
            if ((configuration6 = configuration2.getChild("noaccesscontent", false)) != null) {
                pDFEncryptionParams.setAllowAccessContent(false);
            }
            if ((configuration5 = configuration2.getChild("noassembledoc", false)) != null) {
                pDFEncryptionParams.setAllowAssembleDocument(false);
            }
            if ((configuration4 = configuration2.getChild("noprinthq", false)) != null) {
                pDFEncryptionParams.setAllowPrintHq(false);
            }
            if ((configuration3 = configuration2.getChild("encryption-length", false)) != null) {
                int n = this.checkEncryptionLength(Integer.parseInt(configuration3.getValue(null)));
                pDFEncryptionParams.setEncryptionLengthInBits(n);
            }
        }
        if ((object = configuration.getChild("output-profile", true).getValue(null)) != null) {
            pDFRenderingUtil.setOutputProfileURI((String)object);
        }
        if ((pDFEncryptionParams = configuration.getChild("disable-srgb-colorspace", false)) != null) {
            pDFRenderingUtil.setDisableSRGBColorSpace(pDFEncryptionParams.getValueAsBoolean(false));
        }
        this.setPDFDocVersion(configuration, pDFRenderingUtil);
    }

    private int checkEncryptionLength(int n) {
        int n2 = n;
        if (n < 40) {
            n2 = 40;
        } else if (n > 128) {
            n2 = 128;
        } else if (n % 8 != 0) {
            n2 = Math.round((float)n / 8.0f) * 8;
        }
        if (n2 != n) {
            PDFEventProducer.Provider.get(this.userAgent.getEventBroadcaster()).incorrectEncryptionLength(this, n, n2);
        }
        return n2;
    }

    private void setPDFDocVersion(Configuration configuration, PDFRenderingUtil pDFRenderingUtil) throws FOPException {
        Configuration configuration2 = configuration.getChild("version", false);
        if (configuration2 != null) {
            String string = configuration2.getValue(null);
            if (string != null && string.length() != 0) {
                try {
                    pDFRenderingUtil.setPDFVersion(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new FOPException(illegalArgumentException.getMessage());
                }
            } else {
                throw new FOPException("The PDF version has not been set.");
            }
        }
    }

    public static Map buildFilterMapFromConfiguration(Configuration configuration) throws ConfigurationException {
        HashMap hashMap = new HashMap();
        Configuration[] configurationArray = configuration.getChildren("filterList");
        for (int i = 0; i < configurationArray.length; ++i) {
            Configuration configuration2 = configurationArray[i];
            String string = configuration2.getAttribute("type", null);
            Configuration[] configurationArray2 = configuration2.getChildren("value");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int j = 0; j < configurationArray2.length; ++j) {
                String string2 = configurationArray2[j].getValue();
                arrayList.add(string2);
            }
            if (string == null) {
                string = "default";
            }
            if (!arrayList.isEmpty() && log.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Adding PDF filter");
                if (arrayList.size() != 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append(" for type ").append(string).append(": ");
                for (int j = 0; j < arrayList.size(); ++j) {
                    if (j != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(arrayList.get(j));
                }
                log.debug((Object)stringBuffer.toString());
            }
            if (hashMap.get(string) != null) {
                throw new ConfigurationException("A filterList of type '" + string + "' has already been defined");
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            PDFDocumentHandler pDFDocumentHandler = (PDFDocumentHandler)iFDocumentHandler;
            PDFRenderingUtil pDFRenderingUtil = pDFDocumentHandler.getPDFUtil();
            this.configure(configuration, pDFRenderingUtil);
        }
    }
}

