/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.LinkedList;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.render.pdf.FOToPDFRoleMap;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.xml.sax.Attributes;

class PDFStructureTreeBuilder
implements StructureTreeEventHandler {
    private PDFFactory pdfFactory;
    private PDFLogicalStructureHandler logicalStructureHandler;
    private EventBroadcaster eventBroadcaster;
    private LinkedList<PDFStructElem> ancestors = new LinkedList();
    private PDFStructElem rootStructureElement;

    PDFStructureTreeBuilder() {
    }

    void setPdfFactory(PDFFactory pDFFactory) {
        this.pdfFactory = pDFFactory;
    }

    void setLogicalStructureHandler(PDFLogicalStructureHandler pDFLogicalStructureHandler) {
        this.logicalStructureHandler = pDFLogicalStructureHandler;
        this.createRootStructureElement();
    }

    private void createRootStructureElement() {
        assert (this.rootStructureElement == null);
        PDFParentTree pDFParentTree = this.logicalStructureHandler.getParentTree();
        PDFStructTreeRoot pDFStructTreeRoot = this.pdfFactory.getDocument().makeStructTreeRoot(pDFParentTree);
        this.rootStructureElement = this.createStructureElement("root", pDFStructTreeRoot, null);
        pDFStructTreeRoot.addKid(this.rootStructureElement);
    }

    void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    public void startPageSequence(Locale locale, String string) {
        this.ancestors = new LinkedList();
        PDFStructElem pDFStructElem = this.createStructureElement("page-sequence", this.rootStructureElement, string);
        if (locale != null) {
            pDFStructElem.setLanguage(locale);
        }
        this.rootStructureElement.addKid(pDFStructElem);
        this.ancestors.add(pDFStructElem);
    }

    private PDFStructElem createStructureElement(String string, PDFObject pDFObject, String string2) {
        PDFName pDFName = FOToPDFRoleMap.mapFormattingObject(string, string2, pDFObject, this.eventBroadcaster);
        return this.pdfFactory.getDocument().makeStructureElement(pDFName, pDFObject);
    }

    public void endPageSequence() {
    }

    public StructureTreeElement startNode(String string, Attributes attributes) {
        PDFStructElem pDFStructElem = this.ancestors.getFirst();
        String string2 = attributes.getValue("role");
        PDFStructElem pDFStructElem2 = this.createStructureElement(string, pDFStructElem, string2);
        pDFStructElem.addKid(pDFStructElem2);
        this.ancestors.addFirst(pDFStructElem2);
        return pDFStructElem2;
    }

    public void endNode(String string) {
        this.removeFirstAncestor();
    }

    private void removeFirstAncestor() {
        this.ancestors.removeFirst();
    }

    public StructureTreeElement startImageNode(String string, Attributes attributes) {
        PDFStructElem pDFStructElem = this.ancestors.getFirst();
        String string2 = attributes.getValue("role");
        PDFStructElem pDFStructElem2 = this.createStructureElement(string, pDFStructElem, string2);
        pDFStructElem.addKid(pDFStructElem2);
        String string3 = attributes.getValue("http://xmlgraphics.apache.org/fop/extensions", "alt-text");
        if (string3 != null) {
            pDFStructElem2.put("Alt", string3);
        } else {
            pDFStructElem2.put("Alt", "No alternate text specified");
        }
        this.ancestors.addFirst(pDFStructElem2);
        return pDFStructElem2;
    }

    public StructureTreeElement startReferencedNode(String string, Attributes attributes) {
        PDFStructElem pDFStructElem = this.ancestors.getFirst();
        String string2 = attributes.getValue("role");
        PDFStructElem pDFStructElem2 = "#PCDATA".equals(string) ? new PDFStructElem.Placeholder((PDFObject)pDFStructElem, string) : this.createStructureElement(string, pDFStructElem, string2);
        pDFStructElem.addKid(pDFStructElem2);
        this.ancestors.addFirst(pDFStructElem2);
        return pDFStructElem2;
    }
}

