/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.xmlgraphics.ps.PSResource;

class FontResourceCache {
    private final FontInfo fontInfo;
    private Map fontResources = new HashMap();

    public FontResourceCache(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public PSFontResource getFontResourceForFontKey(String string) {
        PSFontResource pSFontResource = null;
        if (this.fontResources != null) {
            pSFontResource = (PSFontResource)this.fontResources.get(string);
        } else {
            this.fontResources = new HashMap();
        }
        if (pSFontResource == null) {
            pSFontResource = PSFontResource.createFontResource(new PSResource("font", this.getPostScriptNameForFontKey(string)));
            this.fontResources.put(string, pSFontResource);
        }
        return pSFontResource;
    }

    private String getPostScriptNameForFontKey(String string) {
        Map<String, Typeface> map;
        Typeface typeface;
        int n = string.indexOf(95);
        String string2 = null;
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        if ((typeface = (map = this.fontInfo.getFonts()).get(string)) instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        if (typeface == null) {
            throw new IllegalStateException("Font not available: " + string);
        }
        if (string2 == null) {
            return typeface.getEmbedFontName();
        }
        return typeface.getEmbedFontName() + string2;
    }

    public void addAll(Map map) {
        this.fontResources.putAll(map);
    }
}

