/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.ps.FOPProcSet;
import org.apache.fop.render.ps.FontResourceCache;
import org.apache.fop.render.ps.PSEventProducer;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSPainter;
import org.apache.fop.render.ps.PSRendererConfigurator;
import org.apache.fop.render.ps.PSRenderingUtil;
import org.apache.fop.render.ps.ResourceHandler;
import org.apache.fop.render.ps.extensions.PSCommentAfter;
import org.apache.fop.render.ps.extensions.PSCommentBefore;
import org.apache.fop.render.ps.extensions.PSPageTrailerCodeBefore;
import org.apache.fop.render.ps.extensions.PSSetPageDevice;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.xmlgraphics.java2d.Dimension2DDouble;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSDictionary;
import org.apache.xmlgraphics.ps.PSDictionaryFormatException;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSPageDeviceDictionary;
import org.apache.xmlgraphics.ps.PSProcSets;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentHiResBoundingBox;

public class PSDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler {
    private static Log log = LogFactory.getLog(PSDocumentHandler.class);
    protected PSRenderingUtil psUtil;
    protected PSGenerator gen;
    private File tempFile;
    private int currentPageNumber = 0;
    private PageDefinition currentPageDefinition;
    private Rectangle2D documentBoundingBox;
    private List setupCodeList;
    private FontResourceCache fontResources;
    private Map formResources;
    private PSPageDeviceDictionary pageDeviceDictionary;
    private Collection[] comments = new Collection[4];
    private static final int COMMENT_DOCUMENT_HEADER = 0;
    private static final int COMMENT_DOCUMENT_TRAILER = 1;
    private static final int COMMENT_PAGE_TRAILER = 2;
    private static final int PAGE_TRAILER_CODE_BEFORE = 3;
    private PSEventProducer eventProducer;

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/postscript";
    }

    public void setContext(IFContext iFContext) {
        super.setContext(iFContext);
        FOUserAgent fOUserAgent = iFContext.getUserAgent();
        this.psUtil = new PSRenderingUtil(fOUserAgent);
        this.eventProducer = PSEventProducer.Provider.get(fOUserAgent.getEventBroadcaster());
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new PSRendererConfigurator(this.getUserAgent());
    }

    PSRenderingUtil getPSUtil() {
        return this.psUtil;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        this.fontResources = new FontResourceCache(this.getFontInfo());
        try {
            OutputStream outputStream;
            if (this.psUtil.isOptimizeResources()) {
                this.tempFile = File.createTempFile("fop", ".ps");
                outputStream = new FileOutputStream(this.tempFile);
                outputStream = new BufferedOutputStream(outputStream);
            } else {
                outputStream = this.outputStream;
            }
            this.gen = new PSGenerator(outputStream){

                public Source resolveURI(String string) {
                    return PSDocumentHandler.this.getUserAgent().resolveURI(string);
                }
            };
            this.gen.setPSLevel(this.psUtil.getLanguageLevel());
            this.currentPageNumber = 0;
            this.documentBoundingBox = new Rectangle2D.Double();
            this.pageDeviceDictionary = new PSPageDeviceDictionary();
            this.pageDeviceDictionary.setFlushOnRetrieval(!this.psUtil.isDSCComplianceEnabled());
            this.pageDeviceDictionary.put((Object)"/ImagingBBox", (Object)"null");
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startDocument()", iOException);
        }
    }

    private void writeHeader() throws IOException {
        this.gen.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", (Object[])new String[]{this.getUserAgent().getProducer()});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("LanguageLevel", (Object)new Integer(this.gen.getPSLevel()));
        this.gen.writeDSCComment("Pages", new Object[]{DSCConstants.ATEND});
        this.gen.writeDSCComment("BoundingBox", DSCConstants.ATEND);
        this.gen.writeDSCComment("HiResBoundingBox", DSCConstants.ATEND);
        this.gen.writeDSCComment("DocumentSuppliedResources", new Object[]{DSCConstants.ATEND});
        this.writeExtensions(0);
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        PSProcSets.writeStdProcSet((PSGenerator)this.gen);
        PSProcSets.writeEPSProcSet((PSGenerator)this.gen);
        FOPProcSet.INSTANCE.writeTo(this.gen);
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSRenderingUtil.writeSetupCodeList(this.gen, this.setupCodeList, "SetupCode");
        if (!this.psUtil.isOptimizeResources()) {
            this.fontResources.addAll(PSFontUtils.writeFontDict(this.gen, this.fontInfo, this.eventProducer));
        } else {
            this.gen.commentln("%FOPFontSetup");
        }
        this.gen.writeDSCComment("EndSetup");
    }

    public void endDocumentHeader() throws IFException {
        try {
            this.writeHeader();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error writing the PostScript header", iOException);
        }
    }

    public void endDocument() throws IFException {
        try {
            this.gen.writeDSCComment("Trailer");
            this.writeExtensions(1);
            this.gen.writeDSCComment("Pages", (Object)new Integer(this.currentPageNumber));
            new DSCCommentBoundingBox(this.documentBoundingBox).generate(this.gen);
            new DSCCommentHiResBoundingBox(this.documentBoundingBox).generate(this.gen);
            this.gen.getResourceTracker().writeResources(false, this.gen);
            this.gen.writeDSCComment("EOF");
            this.gen.flush();
            log.debug((Object)"Rendering to PostScript complete.");
            if (this.psUtil.isOptimizeResources()) {
                IOUtils.closeQuietly((OutputStream)this.gen.getOutputStream());
                this.rewritePostScriptFile();
            }
            if (this.pageDeviceDictionary != null) {
                this.pageDeviceDictionary.clear();
            }
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endDocument()", iOException);
        }
        super.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewritePostScriptFile() throws IOException {
        log.debug((Object)"Processing PostScript resources...");
        long l = System.currentTimeMillis();
        ResourceTracker resourceTracker = this.gen.getResourceTracker();
        InputStream inputStream = new FileInputStream(this.tempFile);
        inputStream = new BufferedInputStream(inputStream);
        try {
            try {
                ResourceHandler resourceHandler = new ResourceHandler(this.getUserAgent(), this.eventProducer, this.fontInfo, resourceTracker, this.formResources);
                resourceHandler.process(inputStream, this.outputStream, this.currentPageNumber, this.documentBoundingBox);
                this.outputStream.flush();
            }
            catch (DSCException dSCException) {
                throw new RuntimeException(dSCException.getMessage());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            if (!this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
                log.warn((Object)("Could not delete temporary file: " + this.tempFile));
            }
        }
        if (log.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            log.debug((Object)("Resource Processing complete in " + l2 + " ms."));
        }
    }

    public void startPageSequence(String string) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        try {
            if (this.currentPageNumber == 0) {
                // empty if block
            }
            ++this.currentPageNumber;
            this.gen.getResourceTracker().notifyStartNewPage();
            this.gen.getResourceTracker().notifyResourceUsageOnPage(PSProcSets.STD_PROCSET);
            this.gen.writeDSCComment("Page", new Object[]{string, new Integer(this.currentPageNumber)});
            double d = (double)dimension.width / 1000.0;
            double d2 = (double)dimension.height / 1000.0;
            boolean bl = false;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (this.psUtil.isAutoRotateLandscape() && d2 < d) {
                bl = true;
                arrayList.add(new Long(Math.round(d2)));
                arrayList.add(new Long(Math.round(d)));
            } else {
                arrayList.add(new Long(Math.round(d)));
                arrayList.add(new Long(Math.round(d2)));
            }
            this.pageDeviceDictionary.put((Object)"/PageSize", arrayList);
            this.currentPageDefinition = new PageDefinition((Dimension2D)new Dimension2DDouble(d, d2), bl);
            Integer n2 = new Integer(0);
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            if (bl) {
                ((Rectangle2D)double_).setRect(0.0, 0.0, d2, d);
                this.gen.writeDSCComment("PageBoundingBox", new Object[]{n2, n2, new Long(Math.round(d2)), new Long(Math.round(d))});
                this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{n2, n2, new Double(d2), new Double(d)});
                this.gen.writeDSCComment("PageOrientation", (Object)"Landscape");
            } else {
                ((Rectangle2D)double_).setRect(0.0, 0.0, d, d2);
                this.gen.writeDSCComment("PageBoundingBox", new Object[]{n2, n2, new Long(Math.round(d)), new Long(Math.round(d2))});
                this.gen.writeDSCComment("PageHiResBoundingBox", new Object[]{n2, n2, new Double(d), new Double(d2)});
                if (this.psUtil.isAutoRotateLandscape()) {
                    this.gen.writeDSCComment("PageOrientation", (Object)"Portrait");
                }
            }
            this.documentBoundingBox.add(double_);
            this.gen.writeDSCComment("PageResources", new Object[]{DSCConstants.ATEND});
            this.gen.commentln("%FOPSimplePageMaster: " + string2);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startPage()", iOException);
        }
    }

    public void startPageHeader() throws IFException {
        super.startPageHeader();
        try {
            this.gen.writeDSCComment("BeginPageSetup");
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startPageHeader()", iOException);
        }
    }

    public void endPageHeader() throws IFException {
        try {
            if (!this.pageDeviceDictionary.isEmpty()) {
                String string = this.pageDeviceDictionary.getContent();
                string = this.psUtil.isSafeSetPageDevice() ? string + " SSPD" : string + " setpagedevice";
                PSRenderingUtil.writeEnclosedExtensionAttachment(this.gen, new PSSetPageDevice(string));
            }
            double d = this.currentPageDefinition.dimensions.getHeight();
            if (this.currentPageDefinition.rotate) {
                this.gen.writeln(this.gen.formatDouble(d) + " 0 translate");
                this.gen.writeln("90 rotate");
            }
            this.gen.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, d);
            this.gen.writeDSCComment("EndPageSetup");
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPageHeader()", iOException);
        }
        super.endPageHeader();
    }

    private void writeExtensions(int n) throws IOException {
        Collection collection = this.comments[n];
        if (collection != null) {
            PSRenderingUtil.writeEnclosedExtensionAttachments(this.gen, collection);
            collection.clear();
        }
    }

    public IFPainter startPageContent() throws IFException {
        return new PSPainter(this);
    }

    public void endPageContent() throws IFException {
        try {
            this.gen.showPage();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPageContent()", iOException);
        }
    }

    public void startPageTrailer() throws IFException {
        try {
            this.writeExtensions(3);
            super.startPageTrailer();
            this.gen.writeDSCComment("PageTrailer");
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in startPageTrailer()", iOException);
        }
    }

    public void endPageTrailer() throws IFException {
        try {
            this.writeExtensions(2);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPageTrailer()", iOException);
        }
        super.endPageTrailer();
    }

    public void endPage() throws IFException {
        try {
            this.gen.getResourceTracker().writeResources(true, this.gen);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in endPage()", iOException);
        }
        this.currentPageDefinition = null;
    }

    private boolean inPage() {
        return this.currentPageDefinition != null;
    }

    public void handleExtensionObject(Object object) throws IFException {
        try {
            if (object instanceof PSSetupCode) {
                if (this.inPage()) {
                    PSRenderingUtil.writeEnclosedExtensionAttachment(this.gen, (PSSetupCode)object);
                } else {
                    if (this.setupCodeList == null) {
                        this.setupCodeList = new ArrayList();
                    }
                    if (!this.setupCodeList.contains(object)) {
                        this.setupCodeList.add(object);
                    }
                }
            } else if (object instanceof PSSetPageDevice) {
                PSSetPageDevice pSSetPageDevice = (PSSetPageDevice)object;
                String string = pSSetPageDevice.getContent();
                if (string != null) {
                    try {
                        this.pageDeviceDictionary.putAll((Map)PSDictionary.valueOf((String)string));
                    }
                    catch (PSDictionaryFormatException pSDictionaryFormatException) {
                        PSEventProducer pSEventProducer = PSEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                        pSEventProducer.postscriptDictionaryParseError(this, string, (Exception)((Object)pSDictionaryFormatException));
                    }
                }
            } else if (object instanceof PSCommentBefore) {
                if (this.inPage()) {
                    PSRenderingUtil.writeEnclosedExtensionAttachment(this.gen, (PSCommentBefore)object);
                } else {
                    if (this.comments[0] == null) {
                        this.comments[0] = new ArrayList();
                    }
                    this.comments[0].add(object);
                }
            } else if (object instanceof PSCommentAfter) {
                int n;
                int n2 = n = this.inPage() ? 2 : 1;
                if (this.comments[n] == null) {
                    this.comments[n] = new ArrayList();
                }
                this.comments[n].add(object);
            } else if (object instanceof PSPageTrailerCodeBefore) {
                if (this.comments[3] == null) {
                    this.comments[3] = new ArrayList();
                }
                this.comments[3].add(object);
            }
        }
        catch (IOException iOException) {
            throw new IFException("I/O error in handleExtensionObject()", iOException);
        }
    }

    protected PSFontResource getPSResourceForFontKey(String string) {
        return this.fontResources.getFontResourceForFontKey(string);
    }

    protected PSResource getFormForImage(String string) {
        PSResource pSResource;
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("uri must not be empty or null");
        }
        if (this.formResources == null) {
            this.formResources = new HashMap();
        }
        if ((pSResource = (PSResource)this.formResources.get(string)) == null) {
            pSResource = new PSImageFormResource(this.formResources.size() + 1, string);
            this.formResources.put(string, pSResource);
        }
        return pSResource;
    }

    private static final class PageDefinition {
        private Dimension2D dimensions;
        private boolean rotate;

        private PageDefinition(Dimension2D dimension2D, boolean bl) {
            this.dimensions = dimension2D;
            this.rotate = bl;
        }
    }
}

