/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.render.AbstractGraphics2DAdapter;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RendererContext;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSGraphics2DAdapter
extends AbstractGraphics2DAdapter {
    private PSGenerator gen;
    private boolean clip = true;

    public PSGraphics2DAdapter(PSGenerator pSGenerator, boolean bl) {
        this.gen = pSGenerator;
        this.clip = bl;
    }

    public void paintImage(Graphics2DImagePainter graphics2DImagePainter, RendererContext rendererContext, int n, int n2, int n3, int n4) throws IOException {
        float f = (float)n3 / 1000.0f;
        float f2 = (float)n4 / 1000.0f;
        float f3 = (float)n / 1000.0f;
        float f4 = (float)n2 / 1000.0f;
        Dimension dimension = graphics2DImagePainter.getImageSize();
        float f5 = (float)dimension.getWidth() / 1000.0f;
        float f6 = (float)dimension.getHeight() / 1000.0f;
        boolean bl = false;
        if (rendererContext != null) {
            Map map = (Map)rendererContext.getProperty("foreign-attributes");
            bl = map != null && ImageHandlerUtil.isConversionModeBitmap(map);
        }
        float f7 = bl ? 1.0f : f / f5;
        float f8 = bl ? 1.0f : f2 / f6;
        this.gen.commentln("%FOPBeginGraphics2D");
        this.gen.saveGraphicsState();
        if (this.clip) {
            this.gen.writeln("newpath");
            this.gen.defineRect((double)f3, (double)f4, (double)f, (double)f2);
            this.gen.writeln("clip");
        }
        this.gen.concatMatrix((double)f7, 0.0, 0.0, (double)f8, (double)f3, (double)f4);
        PSGraphics2D pSGraphics2D = new PSGraphics2D(false, this.gen);
        pSGraphics2D.setGraphicContext(new GraphicContext());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f3, f4);
        this.gen.getCurrentState().concatMatrix(affineTransform);
        if (bl) {
            int n5 = Math.round(rendererContext.getUserAgent().getTargetResolution());
            RendererContext.RendererContextWrapper rendererContextWrapper = RendererContext.wrapRendererContext(rendererContext);
            BufferedImage bufferedImage = this.paintToBufferedImage(graphics2DImagePainter, rendererContextWrapper, n5, false, false);
            float f9 = 72.0f / rendererContext.getUserAgent().getTargetResolution();
            pSGraphics2D.drawImage((Image)bufferedImage, new AffineTransform(f9, 0.0f, 0.0f, f9, 0.0f, 0.0f), null);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f5, f6);
            graphics2DImagePainter.paint((Graphics2D)pSGraphics2D, (Rectangle2D)double_);
        }
        this.gen.restoreGraphicsState();
        this.gen.commentln("%FOPEndGraphics2D");
    }
}

