/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderJPEG;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRawJPEG
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_JPEG};

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawJPEG imageRawJPEG = (ImageRawJPEG)image;
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        ImageInfo imageInfo = image.getInfo();
        ImageEncoderJPEG imageEncoderJPEG = new ImageEncoderJPEG(imageRawJPEG);
        PSImageUtils.writeImage((ImageEncoder)imageEncoderJPEG, (Dimension)imageInfo.getSize().getDimensionPx(), (String)imageInfo.getOriginalURI(), (Rectangle2D)float_, (ColorSpace)imageRawJPEG.getColorSpace(), (int)8, (boolean)imageRawJPEG.isInverted(), (PSGenerator)pSGenerator);
    }

    public void generateForm(RenderingContext renderingContext, Image image, PSImageFormResource pSImageFormResource) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawJPEG imageRawJPEG = (ImageRawJPEG)image;
        ImageInfo imageInfo = image.getInfo();
        String string = imageInfo.getMimeType() + " " + imageInfo.getOriginalURI();
        ImageEncoderJPEG imageEncoderJPEG = new ImageEncoderJPEG(imageRawJPEG);
        ImageFormGenerator imageFormGenerator = new ImageFormGenerator(pSImageFormResource.getName(), string, imageInfo.getSize().getDimensionPt(), imageInfo.getSize().getDimensionPx(), (ImageEncoder)imageEncoderJPEG, imageRawJPEG.getColorSpace(), imageRawJPEG.isInverted());
        imageFormGenerator.generate(pSGenerator);
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageRawJPEG.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        PSRenderingContext pSRenderingContext;
        if (renderingContext instanceof PSRenderingContext && (pSRenderingContext = (PSRenderingContext)renderingContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawJPEG;
        }
        return false;
    }
}

