/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderPNG;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSImageHandlerRawPNG
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_PNG};

    @Override
    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawPNG imageRawPNG = (ImageRawPNG)image;
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        ImageEncoderPNG imageEncoderPNG = new ImageEncoderPNG(imageRawPNG);
        ImageInfo imageInfo = image.getInfo();
        Dimension dimension = imageInfo.getSize().getDimensionPx();
        String string = image.getClass().getName();
        ColorModel colorModel = imageRawPNG.getColorModel();
        PSImageUtils.writeImage((ImageEncoder)imageEncoderPNG, (Dimension)dimension, (String)string, (Rectangle2D)float_, (ColorModel)colorModel, (PSGenerator)pSGenerator);
    }

    @Override
    public void generateForm(RenderingContext renderingContext, Image image, PSImageFormResource pSImageFormResource) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawPNG imageRawPNG = (ImageRawPNG)image;
        ImageInfo imageInfo = image.getInfo();
        String string = imageInfo.getMimeType() + " " + imageInfo.getOriginalURI();
        ImageEncoderPNG imageEncoderPNG = new ImageEncoderPNG(imageRawPNG);
        ImageFormGenerator imageFormGenerator = new ImageFormGenerator(pSImageFormResource.getName(), string, imageInfo.getSize().getDimensionPt(), imageInfo.getSize().getDimensionPx(), (ImageEncoder)imageEncoderPNG, imageRawPNG.getColorSpace(), false);
        imageFormGenerator.generate(pSGenerator);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Class<ImageRawPNG> getSupportedImageClass() {
        return ImageRawPNG.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        PSRenderingContext pSRenderingContext;
        if (renderingContext instanceof PSRenderingContext && (pSRenderingContext = (PSRenderingContext)renderingContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawPNG;
        }
        return false;
    }
}

