/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.render.AbstractGenericSVGHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.ps.PSBridgeContext;
import org.apache.fop.render.ps.PSRendererContextConstants;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.w3c.dom.Document;

public class PSSVGHandler
extends AbstractGenericSVGHandler
implements PSRendererContextConstants {
    public static PSInfo getPSInfo(RendererContext rendererContext) {
        PSInfo pSInfo = new PSInfo();
        pSInfo.psGenerator = (PSGenerator)rendererContext.getProperty("psGenerator");
        pSInfo.fontInfo = (FontInfo)rendererContext.getProperty("psFontInfo");
        pSInfo.width = (Integer)rendererContext.getProperty("width");
        pSInfo.height = (Integer)rendererContext.getProperty("height");
        pSInfo.currentXPosition = (Integer)rendererContext.getProperty("xpos");
        pSInfo.currentYPosition = (Integer)rendererContext.getProperty("ypos");
        pSInfo.cfg = (Configuration)rendererContext.getProperty("cfg");
        return pSInfo;
    }

    protected void renderSVGDocument(RendererContext rendererContext, Document document) {
        GraphicsNode graphicsNode;
        PSInfo pSInfo = PSSVGHandler.getPSInfo(rendererContext);
        int n = pSInfo.currentXPosition;
        int n2 = pSInfo.currentYPosition;
        PSGenerator pSGenerator = pSInfo.psGenerator;
        boolean bl = false;
        if (rendererContext != null) {
            Map map = (Map)rendererContext.getProperty("foreign-attributes");
            bl = ImageHandlerUtil.isConversionModeBitmap(map);
        }
        if (bl) {
            try {
                super.renderSVGDocument(rendererContext, document);
            }
            catch (IOException iOException) {
                SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
                sVGEventProducer.svgRenderingError(this, iOException, this.getDocumentURI(document));
            }
            return;
        }
        boolean bl2 = false;
        Configuration configuration = pSInfo.getHandlerConfiguration();
        if (configuration != null) {
            bl2 = configuration.getChild("stroke-text", true).getValueAsBoolean(bl2);
        }
        SVGUserAgent sVGUserAgent = new SVGUserAgent(rendererContext.getUserAgent(), new AffineTransform());
        PSGraphics2D pSGraphics2D = new PSGraphics2D(bl2, pSGenerator);
        pSGraphics2D.setGraphicContext(new GraphicContext());
        PSBridgeContext pSBridgeContext = new PSBridgeContext((UserAgent)sVGUserAgent, bl2 ? null : pSInfo.fontInfo, rendererContext.getUserAgent().getFactory().getImageManager(), rendererContext.getUserAgent().getImageSessionContext());
        Document document2 = BatikUtil.cloneSVGDocument(document);
        try {
            GVTBuilder gVTBuilder = new GVTBuilder();
            graphicsNode = gVTBuilder.build((BridgeContext)pSBridgeContext, document2);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt(this, exception, this.getDocumentURI(document));
            return;
        }
        float f = (float)pSBridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f2 = (float)pSBridgeContext.getDocumentSize().getHeight() * 1000.0f;
        float f3 = (float)pSInfo.getWidth() / f;
        float f4 = (float)pSInfo.getHeight() / f2;
        pSBridgeContext = null;
        try {
            pSGenerator.commentln("%FOPBeginSVG");
            pSGenerator.saveGraphicsState();
            pSGenerator.writeln("newpath");
            pSGenerator.defineRect((double)((float)n / 1000.0f), (double)((float)n2 / 1000.0f), (double)((float)pSInfo.getWidth() / 1000.0f), (double)((float)pSInfo.getHeight() / 1000.0f));
            pSGenerator.writeln("clip");
            pSGenerator.concatMatrix((double)f3, 0.0, 0.0, (double)f4, (double)((float)n / 1000.0f), (double)((float)n2 / 1000.0f));
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            pSGenerator.getCurrentState().concatMatrix(affineTransform);
            try {
                graphicsNode.paint((Graphics2D)pSGraphics2D);
            }
            catch (Exception exception) {
                SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
                sVGEventProducer.svgRenderingError(this, exception, this.getDocumentURI(document));
            }
            pSGenerator.restoreGraphicsState();
            pSGenerator.commentln("%FOPEndSVG");
        }
        catch (IOException iOException) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgRenderingError(this, iOException, this.getDocumentURI(document));
        }
    }

    public boolean supportsRenderer(Renderer renderer) {
        return false;
    }

    public static class PSInfo {
        private PSGenerator psGenerator;
        private FontInfo fontInfo;
        private int width;
        private int height;
        private int currentXPosition;
        private int currentYPosition;
        private Configuration cfg;

        public PSGenerator getPSGenerator() {
            return this.psGenerator;
        }

        public void setPsGenerator(PSGenerator pSGenerator) {
            this.psGenerator = pSGenerator;
        }

        public FontInfo getFontInfo() {
            return this.fontInfo;
        }

        public void setFontInfo(FontInfo fontInfo) {
            this.fontInfo = fontInfo;
        }

        public int getCurrentXPosition() {
            return this.currentXPosition;
        }

        public void setCurrentXPosition(int n) {
            this.currentXPosition = n;
        }

        public int getCurrentYPosition() {
            return this.currentYPosition;
        }

        public void setCurrentYPosition(int n) {
            this.currentYPosition = n;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int n) {
            this.height = n;
        }

        public Configuration getHandlerConfiguration() {
            return this.cfg;
        }

        public void setHandlerConfiguration(Configuration configuration) {
            this.cfg = configuration;
        }
    }
}

