/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;

final class FoUnitsConverter {
    private static final FoUnitsConverter INSTANCE = new FoUnitsConverter();
    public static final float POINT_TO_TWIPS = 20.0f;
    public static final float IN_TO_TWIPS = 1440.0f;
    public static final float MM_TO_TWIPS = 56.692913f;
    public static final float CM_TO_TWIPS = 566.92914f;
    private static final Map TWIP_FACTORS = new HashMap();

    private FoUnitsConverter() {
    }

    static FoUnitsConverter getInstance() {
        return INSTANCE;
    }

    float convertToTwips(String string) throws FOPException {
        string = string.trim();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                stringBuffer2.append(string.substring(i).trim());
                break;
            }
            stringBuffer.append(c);
        }
        return this.numberToTwips(stringBuffer.toString(), stringBuffer2.toString());
    }

    private float numberToTwips(String string, String string2) throws FOPException {
        float f = 0.0f;
        try {
            if (string != null && string.trim().length() > 0) {
                f = Float.valueOf(string).floatValue();
            }
        }
        catch (Exception exception) {
            throw new FOPException("number format error: cannot convert '" + string + "' to float value");
        }
        if (string2 != null && string2.trim().length() > 0) {
            Float f2 = (Float)TWIP_FACTORS.get(string2.toLowerCase());
            if (f2 == null) {
                throw new FOPException("conversion factor not found for '" + string2 + "' units");
            }
            f *= f2.floatValue();
        }
        return f;
    }

    int convertFontSize(String string) throws FOPException {
        if (!(string = string.trim()).endsWith("pt")) {
            throw new FOPException("Invalid font size '" + string + "', must end with '" + "pt" + "'");
        }
        float f = 0.0f;
        string = string.substring(0, string.length() - "pt".length());
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            throw new FOPException("Invalid font size value '" + string + "'");
        }
        return (int)((double)f * 2.0);
    }

    public float convertMptToTwips(int n) {
        return (float)n * 20.0f / 1000.0f;
    }

    static {
        TWIP_FACTORS.put("mm", new Float(56.692913f));
        TWIP_FACTORS.put("cm", new Float(566.92914f));
        TWIP_FACTORS.put("pt", new Float(20.0f));
        TWIP_FACTORS.put("in", new Float(1440.0f));
    }
}

