/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.pagination.RegionBA;
import org.apache.fop.fo.pagination.RegionBody;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;

final class PageAttributesConverter {
    private static Log log = new SimpleLog("FOP/RTF");

    private PageAttributesConverter() {
    }

    static RtfAttributes convertPageAttributes(SimplePageMaster simplePageMaster) {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        try {
            Object object;
            RegionBA regionBA = (RegionBA)simplePageMaster.getRegion(57);
            RegionBody regionBody = (RegionBody)simplePageMaster.getRegion(58);
            RegionBA regionBA2 = (RegionBA)simplePageMaster.getRegion(56);
            fOPRtfAttributes.setTwips("paperw", simplePageMaster.getPageWidth());
            fOPRtfAttributes.setTwips("paperh", simplePageMaster.getPageHeight());
            fOPRtfAttributes.set("itap", "0");
            Object object2 = fOPRtfAttributes.getValue("paperw");
            Object object3 = fOPRtfAttributes.getValue("paperh");
            if (object2 instanceof Integer && object3 instanceof Integer && (Integer)object2 > (Integer)object3) {
                fOPRtfAttributes.set("landscape");
            }
            Length length = simplePageMaster.getCommonMarginBlock().marginTop;
            Length length2 = simplePageMaster.getCommonMarginBlock().marginBottom;
            Length length3 = simplePageMaster.getCommonMarginBlock().marginLeft;
            Length length4 = simplePageMaster.getCommonMarginBlock().marginRight;
            Length length5 = length;
            Length length6 = length2;
            Length length7 = length3;
            Length length8 = length4;
            if (regionBody != null) {
                object = regionBody.getCommonMarginBlock();
                length5 = (Length)NumericOp.addition(length, ((CommonMarginBlock)object).marginTop);
                length6 = (Length)NumericOp.addition(length2, ((CommonMarginBlock)object).marginBottom);
                length7 = (Length)NumericOp.addition(length3, ((CommonMarginBlock)object).marginLeft);
                length8 = (Length)NumericOp.addition(length4, ((CommonMarginBlock)object).marginRight);
            }
            fOPRtfAttributes.setTwips("margt", length5);
            fOPRtfAttributes.setTwips("margb", length6);
            fOPRtfAttributes.setTwips("margl", length7);
            fOPRtfAttributes.setTwips("margr", length8);
            object = length;
            if (regionBA != null) {
                object = (Length)NumericOp.addition(length, regionBA.getExtent());
            }
            fOPRtfAttributes.setTwips("headery", (Length)object);
            Length length9 = length2;
            if (regionBA2 != null) {
                length9 = (Length)NumericOp.addition(length2, regionBA2.getExtent());
            }
            fOPRtfAttributes.setTwips("footery", length9);
        }
        catch (Exception exception) {
            log.error((Object)("Exception in convertPageAttributes: " + exception.getMessage() + "- page attributes ignored"));
            fOPRtfAttributes = new FOPRtfAttributes();
        }
        return fOPRtfAttributes;
    }
}

