/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.render.rtf.BorderAttributesConverter;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.FoUnitsConverter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfColorTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFontManager;

final class TextAttributesConverter {
    private static Log log = LogFactory.getLog(TextAttributesConverter.class);

    private TextAttributesConverter() {
    }

    public static RtfAttributes convertAttributes(Block block) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(block.getCommonFont(), fOPRtfAttributes);
        TextAttributesConverter.attrFontColor(block.getColor(), fOPRtfAttributes);
        TextAttributesConverter.attrBlockBackgroundColor(block.getCommonBorderPaddingBackground(), fOPRtfAttributes);
        TextAttributesConverter.attrBlockMargin(block.getCommonMarginBlock(), fOPRtfAttributes);
        TextAttributesConverter.attrBlockTextAlign(block.getTextAlign(), fOPRtfAttributes);
        TextAttributesConverter.attrBorder(block.getCommonBorderPaddingBackground(), fOPRtfAttributes, block);
        TextAttributesConverter.attrBreak(block, fOPRtfAttributes);
        return fOPRtfAttributes;
    }

    private static void attrBreak(Block block, FOPRtfAttributes fOPRtfAttributes) {
        int n = block.getBreakBefore();
        if (n != 9) {
            boolean bl = false;
            FONode fONode = block;
            while (fONode.getParent() != null) {
                if (!((fONode = fONode.getParent()) instanceof TableCell)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                fOPRtfAttributes.set("sect");
                switch (n) {
                    case 44: {
                        fOPRtfAttributes.set("sbkeven");
                        break;
                    }
                    case 100: {
                        fOPRtfAttributes.set("sbkodd");
                        break;
                    }
                    case 28: {
                        fOPRtfAttributes.set("sbkcol");
                        break;
                    }
                    default: {
                        fOPRtfAttributes.set("sbkpage");
                        break;
                    }
                }
            } else {
                log.warn((Object)"Cannot create break-before for a block inside a table.");
            }
        }
    }

    public static RtfAttributes convertBlockContainerAttributes(BlockContainer blockContainer) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        TextAttributesConverter.attrBackgroundColor(blockContainer.getCommonBorderPaddingBackground(), fOPRtfAttributes);
        TextAttributesConverter.attrBlockMargin(blockContainer.getCommonMarginBlock(), fOPRtfAttributes);
        TextAttributesConverter.attrBorder(blockContainer.getCommonBorderPaddingBackground(), fOPRtfAttributes, blockContainer);
        return fOPRtfAttributes;
    }

    public static RtfAttributes convertCharacterAttributes(FOText fOText) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(fOText.getCommonFont(), fOPRtfAttributes);
        TextAttributesConverter.attrFontColor(fOText.getColor(), fOPRtfAttributes);
        TextAttributesConverter.attrTextDecoration(fOText.getTextDecoration(), fOPRtfAttributes);
        TextAttributesConverter.attrBaseLineShift(fOText.getBaseLineShift(), fOPRtfAttributes);
        return fOPRtfAttributes;
    }

    public static RtfAttributes convertCharacterAttributes(PageNumber pageNumber) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(pageNumber.getCommonFont(), fOPRtfAttributes);
        TextAttributesConverter.attrTextDecoration(pageNumber.getTextDecoration(), fOPRtfAttributes);
        TextAttributesConverter.attrBackgroundColor(pageNumber.getCommonBorderPaddingBackground(), fOPRtfAttributes);
        return fOPRtfAttributes;
    }

    public static RtfAttributes convertCharacterAttributes(Inline inline) throws FOPException {
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        TextAttributesConverter.attrFont(inline.getCommonFont(), fOPRtfAttributes);
        TextAttributesConverter.attrFontColor(inline.getColor(), fOPRtfAttributes);
        TextAttributesConverter.attrBackgroundColor(inline.getCommonBorderPaddingBackground(), fOPRtfAttributes);
        TextAttributesConverter.attrInlineBorder(inline.getCommonBorderPaddingBackground(), fOPRtfAttributes);
        return fOPRtfAttributes;
    }

    public static RtfAttributes convertLeaderAttributes(Leader leader, PercentBaseContext percentBaseContext) throws FOPException {
        boolean bl = false;
        FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
        fOPRtfAttributes.set("f", RtfFontManager.getInstance().getFontNumber(leader.getCommonFont().getFirstFontFamily()));
        if (leader.getLeaderLength() != null) {
            fOPRtfAttributes.set("lwidth", TextAttributesConverter.convertMptToTwips(leader.getLeaderLength().getMaximum(percentBaseContext).getLength().getValue(percentBaseContext)));
            if (leader.getLeaderLength().getMaximum(percentBaseContext) instanceof PercentLength && ((PercentLength)leader.getLeaderLength().getMaximum(percentBaseContext)).getString().equals("100.0%")) {
                fOPRtfAttributes.set("tabuse", 1);
                bl = true;
            }
        }
        TextAttributesConverter.attrFontColor(leader.getColor(), fOPRtfAttributes);
        if (leader.getLeaderPatternWidth() != null) {
            // empty if block
        }
        block0 : switch (leader.getLeaderPattern()) {
            case 35: {
                if (bl) {
                    fOPRtfAttributes.set("tablead", "tldot");
                    break;
                }
                fOPRtfAttributes.set("tablead", "uld");
                break;
            }
            case 134: {
                break;
            }
            case 123: {
                if (leader.getRuleThickness() != null) {
                    log.warn((Object)"RTF: fo:leader rule-thickness not supported");
                }
                switch (leader.getRuleStyle()) {
                    case 133: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tlth");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "ulth");
                        break block0;
                    }
                    case 31: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tlmdot");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "uldash");
                        break block0;
                    }
                    case 36: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tldot");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "uld");
                        break block0;
                    }
                    case 37: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tleq");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "uldb");
                        break block0;
                    }
                    case 55: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tlhyph");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "ulhwave");
                        break block0;
                    }
                    case 119: {
                        if (bl) {
                            fOPRtfAttributes.set("tablead", "tlul");
                            break block0;
                        }
                        fOPRtfAttributes.set("tablead", "ulthdashdd");
                        break block0;
                    }
                }
                break;
            }
            case 158: {
                log.warn((Object)"RTF: fo:leader use-content not supported");
                break;
            }
        }
        if (leader.getLeaderAlignment() == 109) {
            log.warn((Object)"RTF: fo:leader reference-area not supported");
        }
        return fOPRtfAttributes;
    }

    private static int convertMptToTwips(int n) {
        return Math.round(FoUnitsConverter.getInstance().convertMptToTwips(n));
    }

    private static void attrFont(CommonFont commonFont, FOPRtfAttributes fOPRtfAttributes) {
        fOPRtfAttributes.set("f", RtfFontManager.getInstance().getFontNumber(commonFont.getFirstFontFamily()));
        fOPRtfAttributes.setHalfPoints("fs", commonFont.fontSize);
        if (commonFont.getFontWeight() == 175 || commonFont.getFontWeight() == 176 || commonFont.getFontWeight() == 177) {
            fOPRtfAttributes.set("b", 1);
        } else {
            fOPRtfAttributes.set("b", 0);
        }
        if (commonFont.getFontStyle() == 164) {
            fOPRtfAttributes.set("i", 1);
        } else {
            fOPRtfAttributes.set("i", 0);
        }
    }

    private static void attrFontColor(Color color, RtfAttributes rtfAttributes) {
        if (color != null && (color.getAlpha() != 0 || color.getRed() != 0 || color.getGreen() != 0 || color.getBlue() != 0)) {
            rtfAttributes.set("cf", TextAttributesConverter.convertFOPColorToRTF(color));
        }
    }

    private static void attrTextDecoration(CommonTextDecoration commonTextDecoration, RtfAttributes rtfAttributes) {
        if (commonTextDecoration == null) {
            rtfAttributes.set("ul", 0);
            rtfAttributes.set("strike", 0);
            return;
        }
        if (commonTextDecoration.hasUnderline()) {
            rtfAttributes.set("ul", 1);
        } else {
            rtfAttributes.set("ul", 0);
        }
        if (commonTextDecoration.hasLineThrough()) {
            rtfAttributes.set("strike", 1);
        } else {
            rtfAttributes.set("strike", 0);
        }
    }

    private static void attrBlockMargin(CommonMarginBlock commonMarginBlock, FOPRtfAttributes fOPRtfAttributes) {
        fOPRtfAttributes.setTwips("sb", commonMarginBlock.spaceBefore.getOptimum(null).getLength());
        fOPRtfAttributes.setTwips("sa", commonMarginBlock.spaceAfter.getOptimum(null).getLength());
        fOPRtfAttributes.setTwips("li", commonMarginBlock.startIndent);
        fOPRtfAttributes.setTwips("ri", commonMarginBlock.endIndent);
    }

    private static void attrBlockTextAlign(int n, RtfAttributes rtfAttributes) {
        String string = null;
        switch (n) {
            case 23: {
                string = "qc";
                break;
            }
            case 39: {
                string = "qr";
                break;
            }
            case 70: {
                string = "qj";
                break;
            }
            default: {
                string = "ql";
            }
        }
        rtfAttributes.set(string);
    }

    private static void attrBlockBackgroundColor(CommonBorderPaddingBackground commonBorderPaddingBackground, RtfAttributes rtfAttributes) {
        if (commonBorderPaddingBackground.hasBackground()) {
            rtfAttributes.set("shading", 10000);
            rtfAttributes.set("cfpat", TextAttributesConverter.convertFOPColorToRTF(commonBorderPaddingBackground.backgroundColor));
        }
    }

    private static void attrBorder(CommonBorderPaddingBackground commonBorderPaddingBackground, RtfAttributes rtfAttributes, FONode fONode) {
        if (TextAttributesConverter.hasBorder(fONode.getParent())) {
            TextAttributesConverter.attrInlineBorder(commonBorderPaddingBackground, rtfAttributes);
            return;
        }
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 0, rtfAttributes, "brdrt");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 1, rtfAttributes, "brdrb");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 2, rtfAttributes, "brdrl");
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 3, rtfAttributes, "brdrr");
    }

    private static boolean hasBorder(FONode fONode) {
        while (fONode != null) {
            FObj fObj;
            CommonBorderPaddingBackground commonBorderPaddingBackground = null;
            if (fONode instanceof Block) {
                fObj = (Block)fONode;
                commonBorderPaddingBackground = ((Block)fObj).getCommonBorderPaddingBackground();
            } else if (fONode instanceof BlockContainer) {
                fObj = (BlockContainer)fONode;
                commonBorderPaddingBackground = ((BlockContainer)fObj).getCommonBorderPaddingBackground();
            }
            if (commonBorderPaddingBackground != null && commonBorderPaddingBackground.hasBorder()) {
                return true;
            }
            fONode = fONode.getParent();
        }
        return false;
    }

    private static void attrInlineBorder(CommonBorderPaddingBackground commonBorderPaddingBackground, RtfAttributes rtfAttributes) {
        BorderAttributesConverter.makeBorder(commonBorderPaddingBackground, 0, rtfAttributes, "chbrdr");
    }

    private static void attrBackgroundColor(CommonBorderPaddingBackground commonBorderPaddingBackground, RtfAttributes rtfAttributes) {
        Color color = commonBorderPaddingBackground.backgroundColor;
        int n = 0;
        if (color == null || color.getRed() == 0 && color.getGreen() == 0 && color.getBlue() == 0 && color.getAlpha() == 0) {
            return;
        }
        n = TextAttributesConverter.convertFOPColorToRTF(color);
        rtfAttributes.set("chcbpat", n);
    }

    private static void attrBaseLineShift(Length length, RtfAttributes rtfAttributes) {
        int n = length.getEnum();
        if (n == 138) {
            rtfAttributes.set("super");
        } else if (n == 137) {
            rtfAttributes.set("sub");
        }
    }

    public static int convertFOPColorToRTF(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return RtfColorTable.getInstance().getColorNumber(n, n2, n3);
    }
}

