/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfStructureException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfOptions;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public class RtfContainer
extends RtfElement {
    private LinkedList children;
    private RtfOptions options = new RtfOptions();
    private RtfElement lastChild;

    RtfContainer(RtfContainer rtfContainer, Writer writer) throws IOException {
        this(rtfContainer, writer, null);
    }

    RtfContainer(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfContainer, writer, rtfAttributes);
        this.children = new LinkedList();
    }

    public void setOptions(RtfOptions rtfOptions) {
        this.options = rtfOptions;
    }

    protected void addChild(RtfElement rtfElement) throws RtfStructureException {
        if (this.isClosed()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("addChild: container already closed (parent=");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(" child=");
            stringBuffer.append(rtfElement.getClass().getName());
            stringBuffer.append(")");
            String string = stringBuffer.toString();
            RtfFile rtfFile = this.getRtfFile();
        }
        this.children.add(rtfElement);
        this.lastChild = rtfElement;
    }

    public List getChildren() {
        return (List)this.children.clone();
    }

    public int getChildCount() {
        return this.children.size();
    }

    private int findChildren(RtfElement rtfElement, int n) {
        for (RtfElement rtfElement2 : this.getChildren()) {
            int n2;
            if (rtfElement == rtfElement2) {
                return n;
            }
            if (!(rtfElement2 instanceof RtfContainer) || (n2 = ((RtfContainer)rtfElement2).findChildren(rtfElement, n + 1)) == -1) continue;
            return n2;
        }
        return -1;
    }

    public int findChildren(RtfElement rtfElement) {
        return this.findChildren(rtfElement, 0);
    }

    public boolean setChildren(List list) {
        if (list instanceof LinkedList) {
            this.children = (LinkedList)list;
            return true;
        }
        return false;
    }

    protected void writeRtfContent() throws IOException {
        for (RtfElement rtfElement : this.children) {
            rtfElement.writeRtf();
        }
    }

    RtfOptions getOptions() {
        return this.options;
    }

    boolean containsText() {
        boolean bl = false;
        for (RtfElement rtfElement : this.children) {
            if (rtfElement instanceof RtfText) {
                bl = !rtfElement.isEmpty();
            } else if (rtfElement instanceof RtfContainer && ((RtfContainer)rtfElement).containsText()) {
                bl = true;
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }

    void dump(Writer writer, int n) throws IOException {
        super.dump(writer, n);
        for (RtfElement rtfElement : this.children) {
            rtfElement.dump(writer, n + 1);
        }
    }

    public String toString() {
        return super.toString() + " (" + this.getChildCount() + " children)";
    }

    protected boolean okToWriteRtf() {
        boolean bl;
        boolean bl2 = bl = super.okToWriteRtf() && !this.isEmpty();
        if (bl && !this.options.renderContainer(this)) {
            bl = false;
        }
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = true;
        for (RtfElement rtfElement : this.children) {
            if (rtfElement.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

