/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfExtraRowSet
extends RtfContainer {
    static final int DEFAULT_IDNUM = 0;
    private ITableColumnsInfo parentITableColumnsInfo = null;
    private final List cells = new LinkedList();
    private int maxRowIndex;

    RtfExtraRowSet(Writer writer) throws IOException {
        super(null, writer);
    }

    int addTable(RtfTable rtfTable, int n, int n2) {
        for (RtfElement rtfElement : rtfTable.getChildren()) {
            if (!(rtfElement instanceof RtfTableRow)) continue;
            this.addRow((RtfTableRow)rtfElement, n, n2);
            this.maxRowIndex = Math.max(++n, this.maxRowIndex);
        }
        return n;
    }

    private void addRow(RtfTableRow rtfTableRow, int n, int n2) {
        for (RtfElement rtfElement : rtfTableRow.getChildren()) {
            if (!(rtfElement instanceof RtfTableCell)) continue;
            RtfTableCell rtfTableCell = (RtfTableCell)rtfElement;
            this.cells.add(new PositionedCell(rtfTableCell, n, n2));
            n2 += rtfTableCell.getCellWidth();
        }
    }

    RtfTableCell createExtraCell(int n, int n2, int n3, RtfAttributes rtfAttributes) throws IOException {
        RtfTableCell rtfTableCell = new RtfTableCell(null, this.writer, n3, rtfAttributes, 0);
        this.cells.add(new PositionedCell(rtfTableCell, n, n2));
        return rtfTableCell;
    }

    protected void writeRtfContent() throws IOException {
        Collections.sort(this.cells);
        LinkedList<PositionedCell> linkedList = null;
        int n = -1;
        for (PositionedCell positionedCell : this.cells) {
            if (positionedCell.rowIndex != n) {
                if (linkedList != null) {
                    this.writeRow(linkedList);
                }
                n = positionedCell.rowIndex;
                linkedList = new LinkedList<PositionedCell>();
            }
            linkedList.add(positionedCell);
        }
        if (linkedList != null) {
            this.writeRow(linkedList);
        }
    }

    private void writeRow(List list) throws IOException {
        if (RtfExtraRowSet.allCellsEmpty(list)) {
            return;
        }
        RtfTableRow rtfTableRow = new RtfTableRow(null, this.writer, 0);
        int n = 0;
        ITableColumnsInfo iTableColumnsInfo = this.getParentITableColumnsInfo();
        iTableColumnsInfo.selectFirstColumn();
        float f = 0.0f;
        float f2 = 0.0f;
        for (PositionedCell positionedCell : list) {
            if (n == 0 && positionedCell.xOffset > 0) {
                for (int i = 0; f < (float)positionedCell.xOffset && i < iTableColumnsInfo.getNumberOfColumns(); f += iTableColumnsInfo.getColumnWidth(), ++i) {
                    rtfTableRow.newTableCellMergedVertically((int)iTableColumnsInfo.getColumnWidth(), ((PositionedCell)positionedCell).cell.attrib);
                    iTableColumnsInfo.selectNextColumn();
                }
            }
            rtfTableRow.addChild(positionedCell.cell);
            f2 = positionedCell.xOffset + positionedCell.cell.getCellWidth();
            ++n;
        }
        if (iTableColumnsInfo.getColumnIndex() < iTableColumnsInfo.getNumberOfColumns() - 1) {
            iTableColumnsInfo.selectNextColumn();
            while (iTableColumnsInfo.getColumnIndex() < iTableColumnsInfo.getNumberOfColumns()) {
                rtfTableRow.newTableCellMergedVertically((int)iTableColumnsInfo.getColumnWidth(), this.attrib);
                iTableColumnsInfo.selectNextColumn();
            }
        }
        rtfTableRow.writeRtf();
    }

    private static boolean allCellsEmpty(List list) {
        boolean bl = true;
        for (PositionedCell positionedCell : list) {
            if (!positionedCell.cell.containsText()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isEmpty() {
        return false;
    }

    public ITableColumnsInfo getParentITableColumnsInfo() {
        return this.parentITableColumnsInfo;
    }

    public void setParentITableColumnsInfo(ITableColumnsInfo iTableColumnsInfo) {
        this.parentITableColumnsInfo = iTableColumnsInfo;
    }

    private static class PositionedCell
    implements Comparable {
        private final RtfTableCell cell;
        private final int xOffset;
        private final int rowIndex;

        PositionedCell(RtfTableCell rtfTableCell, int n, int n2) {
            this.cell = rtfTableCell;
            this.xOffset = n2;
            this.rowIndex = n;
        }

        public String toString() {
            return "PositionedCell: row " + this.rowIndex + ", offset " + this.xOffset;
        }

        public int compareTo(Object object) {
            int n = 0;
            if (object == null) {
                n = 1;
            } else if (!(object instanceof PositionedCell)) {
                n = 1;
            } else {
                PositionedCell positionedCell = (PositionedCell)object;
                if (this.rowIndex < positionedCell.rowIndex) {
                    n = -1;
                } else if (this.rowIndex > positionedCell.rowIndex) {
                    n = 1;
                } else if (this.xOffset < positionedCell.xOffset) {
                    n = -1;
                } else if (this.xOffset > positionedCell.xOffset) {
                    n = 1;
                }
            }
            return n;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= n * 11 + this.xOffset;
            n ^= n * 19 + this.rowIndex;
            return n;
        }

        public boolean equals(Object object) {
            return object != null && this.compareTo(object) == 0;
        }
    }
}

