/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;

public class RtfSpaceSplitter {
    private RtfAttributes commonAttributes;
    private int spaceBefore;
    private int spaceAfter;
    private boolean updatingSpaceBefore;
    private RtfAttributes spaceBeforeCandidate;
    private RtfAttributes spaceAfterCandidate;

    public RtfSpaceSplitter(RtfAttributes rtfAttributes, int n) {
        this.commonAttributes = rtfAttributes;
        this.updatingSpaceBefore = true;
        this.spaceBeforeCandidate = null;
        this.spaceAfterCandidate = null;
        this.spaceBefore = this.split("sb") + n;
        this.spaceAfter = this.split("sa");
    }

    public int split(String string) {
        Integer n = (Integer)this.commonAttributes.getValue(string);
        if (n == null) {
            n = new Integer(0);
        }
        this.commonAttributes.unset(string);
        return n;
    }

    public RtfAttributes getCommonAttributes() {
        return this.commonAttributes;
    }

    public int getSpaceBefore() {
        return this.spaceBefore;
    }

    public void setSpaceBeforeCandidate(RtfAttributes rtfAttributes) {
        if (this.updatingSpaceBefore) {
            this.spaceBeforeCandidate = rtfAttributes;
        }
    }

    public void setSpaceAfterCandidate(RtfAttributes rtfAttributes) {
        this.spaceAfterCandidate = rtfAttributes;
    }

    public boolean isBeforeCadidateSet() {
        return this.spaceBeforeCandidate != null;
    }

    public boolean isAfterCadidateSet() {
        return this.spaceAfterCandidate != null;
    }

    public void stopUpdatingSpaceBefore() {
        this.updatingSpaceBefore = false;
    }

    public int flush() {
        int n = 0;
        if (!this.isBeforeCadidateSet()) {
            n += this.spaceBefore;
        } else {
            this.spaceBeforeCandidate.addIntegerValue(this.spaceBefore, "sb");
        }
        if (!this.isAfterCadidateSet()) {
            n += this.spaceAfter;
        } else {
            this.spaceAfterCandidate.addIntegerValue(this.spaceAfter, "sa");
        }
        return n;
    }
}

