/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.util.StringTokenizer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfString;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

final class WhitespaceCollapser {
    private static final String SPACE = " ";
    private boolean lastEndSpace = true;

    WhitespaceCollapser(RtfContainer rtfContainer) {
        for (Object e : rtfContainer.getChildren()) {
            RtfElement rtfElement;
            if (e instanceof RtfText) {
                rtfElement = (RtfText)e;
                this.processText((RtfText)rtfElement);
                continue;
            }
            if (e instanceof RtfString) {
                rtfElement = (RtfString)e;
                this.processString((RtfString)rtfElement);
                continue;
            }
            this.lastEndSpace = true;
        }
    }

    public boolean getLastEndSpace() {
        return this.lastEndSpace;
    }

    private void processText(RtfText rtfText) {
        String string = this.processString(rtfText.getText());
        if (string != null) {
            rtfText.setText(string);
        }
    }

    private void processString(RtfString rtfString) {
        String string = this.processString(rtfString.getText());
        if (string != null) {
            rtfString.setText(string);
        }
    }

    private String processString(String string) {
        String string2 = string;
        if (string2 == null) {
            return null;
        }
        if (string2.length() > 0) {
            boolean bl = string2.trim().length() == 0;
            boolean bl2 = bl || Character.isWhitespace(string2.charAt(string2.length() - 1));
            boolean bl3 = Character.isWhitespace(string2.charAt(0));
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            if (bl) {
                if (!this.lastEndSpace) {
                    stringBuffer.append(SPACE);
                }
            } else {
                boolean bl4 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
                while (stringTokenizer.hasMoreTokens()) {
                    if (bl4 && bl3 && !this.lastEndSpace) {
                        stringBuffer.append(SPACE);
                    }
                    bl4 = false;
                    stringBuffer.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens() && !bl2) continue;
                    stringBuffer.append(SPACE);
                }
            }
            this.lastEndSpace = bl2;
            return stringBuffer.toString();
        }
        return "";
    }
}

