/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontInfoConfigurator;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.render.pdf.PDFRendererConfigurator;
import org.apache.fop.svg.PDFDocumentGraphics2D;

public class PDFDocumentGraphics2DConfigurator {
    public void configure(PDFDocumentGraphics2D pDFDocumentGraphics2D, Configuration configuration, boolean bl) throws ConfigurationException {
        PDFDocument pDFDocument = pDFDocumentGraphics2D.getPDFDocument();
        pDFDocument.setFilterMap(PDFRendererConfigurator.buildFilterMapFromConfiguration(configuration));
        try {
            FontInfo fontInfo = PDFDocumentGraphics2DConfigurator.createFontInfo(configuration, bl);
            pDFDocumentGraphics2D.setFontInfo(fontInfo);
        }
        catch (FOPException fOPException) {
            throw new ConfigurationException("Error while setting up fonts", (Throwable)fOPException);
        }
    }

    public static FontInfo createFontInfo(Configuration configuration, boolean bl) throws FOPException {
        Object object;
        FontInfo fontInfo = new FontInfo();
        FontResolver fontResolver = FontManager.createMinimalFontResolver(bl);
        FontManager fontManager = new FontManager();
        if (configuration != null) {
            object = new FontManagerConfigurator(configuration);
            ((FontManagerConfigurator)object).configure(fontManager, false);
        }
        object = new ArrayList();
        object.add(new Base14FontCollection(fontManager.isBase14KerningEnabled()));
        if (configuration != null) {
            FontEventListener fontEventListener = null;
            FontInfoConfigurator fontInfoConfigurator = new FontInfoConfigurator(configuration, fontManager, fontResolver, fontEventListener, false);
            ArrayList<EmbedFontInfo> arrayList = new ArrayList<EmbedFontInfo>();
            fontInfoConfigurator.configure(arrayList);
            object.add(new CustomFontCollection(fontResolver, arrayList, fontResolver.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, object.toArray(new FontCollection[object.size()]));
        return fontInfo;
    }
}

