/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.Typeface;

public abstract class PDFTextUtil
extends org.apache.fop.pdf.PDFTextUtil {
    private FontInfo fontInfo;
    private Font[] fonts;
    private Font font;
    private int encoding;

    public PDFTextUtil(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    protected void initValues() {
        super.initValues();
        this.font = null;
    }

    public void setFonts(Font[] fontArray) {
        this.fonts = fontArray;
    }

    public void setFont(Font font) {
        this.setFonts(new Font[]{font});
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public int getCurrentEncoding() {
        return this.encoding;
    }

    public void setCurrentFont(Font font) {
        this.font = font;
    }

    public void setCurrentEncoding(int n) {
        this.encoding = n;
    }

    protected boolean isMultiByteFont(String string) {
        Typeface typeface = this.fontInfo.getFonts().get(string);
        return typeface.isMultiByte();
    }

    public void writeTf(Font font) {
        String string = font.getFontName();
        float f = (float)font.getFontSize() / 1000.0f;
        boolean bl = this.isMultiByteFont(string);
        if (!bl && this.encoding != 0) {
            this.updateTf(string + "_" + Integer.toString(this.encoding), f, bl);
        } else {
            this.updateTf(string, f, bl);
        }
    }

    public Font selectFontForChar(char c) {
        int n = this.fonts.length;
        for (int i = 0; i < n; ++i) {
            if (!this.fonts[i].hasChar(c)) continue;
            return this.fonts[i];
        }
        return this.fonts[0];
    }

    public void writeTJChar(char c) {
        char c2 = this.font.mapChar(c);
        this.writeTJMappedChar(c2);
    }
}

