/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;

public class FileCompare {
    private String referenceDirectory;
    private String testDirectory;
    private String[] filenameList;
    private String filenames;

    public void setTestDirectory(String string) {
        if (!(string.endsWith("/") | string.endsWith("\\"))) {
            string = string + File.separator;
        }
        this.testDirectory = string;
    }

    public void setReferenceDirectory(String string) {
        if (!(string.endsWith("/") | string.endsWith("\\"))) {
            string = string + File.separator;
        }
        this.referenceDirectory = string;
    }

    public void setFilenames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>(20);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.filenameList = new String[arrayList.size()];
        this.filenameList = arrayList.toArray(new String[0]);
    }

    public static boolean compareFiles(File file, File file2) throws IOException {
        return FileCompare.compareFileSize(file, file2) && FileCompare.compareBytes(file, file2);
    }

    private static boolean compareBytes(File file, File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            if (n == n2) {
                n = bufferedInputStream.read();
                n2 = bufferedInputStream2.read();
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean compareFileSize(File file, File file2) {
        return file.length() == file2.length();
    }

    private boolean filesExist(File file, File file2) {
        if (!file.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.referenceDirectory + file.getName() + " doesn't exist!");
            return false;
        }
        if (!file2.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.testDirectory + file2.getName() + " doesn't exist!");
            return false;
        }
        return true;
    }

    private void writeHeader(PrintWriter printWriter) {
        String string = DateFormat.getDateTimeInstance(2, 2).format(new Date());
        printWriter.println("<html><head><title>Test Results</title></head><body>\n");
        printWriter.println("<h2>Compare Results<br>");
        printWriter.println("<font size='1'>created " + string + "</font></h2>");
        printWriter.println("<table cellpadding='10' border='2'><thead><th align='center'>reference file</th><th align='center'>test file</th><th align='center'>identical?</th></thead>");
    }

    public void execute() throws BuildException {
        boolean bl = false;
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter("results.html"), true);
            this.writeHeader(printWriter);
            for (int i = 0; i < this.filenameList.length; ++i) {
                File file;
                File file2 = new File(this.referenceDirectory + this.filenameList[i]);
                if (!this.filesExist(file2, file = new File(this.testDirectory + this.filenameList[i]))) continue;
                bl = FileCompare.compareFileSize(file2, file);
                if (bl) {
                    bl = FileCompare.compareBytes(file2, file);
                }
                if (!bl) {
                    System.out.println("Task Compare: \nFiles " + this.referenceDirectory + file2.getName() + " - " + this.testDirectory + file.getName() + " are *not* identical.");
                    printWriter.println("<tr><td><a href='" + this.referenceDirectory + file2.getName() + "'>" + file2.getName() + "</a> </td><td> <a href='" + this.testDirectory + file.getName() + "'>" + file.getName() + "</a>" + " </td><td><font color='red'>No</font></td></tr>");
                    continue;
                }
                printWriter.println("<tr><td><a href='" + this.referenceDirectory + file2.getName() + "'>" + file2.getName() + "</a> </td><td> <a href='" + this.testDirectory + file.getName() + "'>" + file.getName() + "</a>" + " </td><td>Yes</td></tr>");
            }
            printWriter.println("</table></html>");
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + iOException);
        }
    }
}

