/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.awt.Color;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.traits.BorderStyle;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class BorderProps
implements Serializable {
    private static final long serialVersionUID = -886871454032189183L;
    public static final int SEPARATE = 0;
    public static final int COLLAPSE_INNER = 1;
    public static final int COLLAPSE_OUTER = 2;
    public int style;
    public Color color;
    public int width;
    public int mode;

    public BorderProps(int n, int n2, Color color, int n3) {
        this.style = n;
        this.width = n2;
        this.color = color;
        this.mode = n3;
    }

    public BorderProps(String string, int n, Color color, int n2) {
        this(BorderProps.getConstantForStyle(string), n, color, n2);
    }

    public static int getClippedWidth(BorderProps borderProps) {
        if (borderProps != null && borderProps.mode != 0) {
            return borderProps.width / 2;
        }
        return 0;
    }

    private String getStyleString() {
        return BorderStyle.valueOf(this.style).getName();
    }

    private static int getConstantForStyle(String string) {
        return BorderStyle.valueOf(string).getEnumValue();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof BorderProps) {
            BorderProps borderProps = (BorderProps)object;
            return this.style == borderProps.style && ColorUtil.isSameColor((Color)this.color, (Color)borderProps.color) && this.width == borderProps.width && this.mode == borderProps.mode;
        }
        return false;
    }

    public static BorderProps valueOf(FOUserAgent fOUserAgent, String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            Object object;
            string = string.substring(1, string.length() - 1);
            Pattern pattern = Pattern.compile("([^,\\(]+(?:\\(.*\\))?)");
            Matcher matcher = pattern.matcher(string);
            boolean bl = matcher.find();
            String string2 = matcher.group();
            bl = matcher.find();
            String string3 = matcher.group();
            bl = matcher.find();
            int n = Integer.parseInt(matcher.group());
            int n2 = 0;
            bl = matcher.find();
            if (bl) {
                object = matcher.group();
                if ("collapse-inner".equalsIgnoreCase((String)object)) {
                    n2 = 1;
                } else if ("collapse-outer".equalsIgnoreCase((String)object)) {
                    n2 = 2;
                }
            }
            try {
                object = org.apache.fop.util.ColorUtil.parseColorString(fOUserAgent, string3);
            }
            catch (PropertyException propertyException) {
                throw new IllegalArgumentException(propertyException.getMessage());
            }
            return new BorderProps(string2, n, (Color)object, n2);
        }
        throw new IllegalArgumentException("BorderProps must be surrounded by parentheses");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.getStyleString());
        stringBuffer.append(',');
        stringBuffer.append(org.apache.fop.util.ColorUtil.colorToString(this.color));
        stringBuffer.append(',');
        stringBuffer.append(this.width);
        if (this.mode != 0) {
            stringBuffer.append(',');
            if (this.mode == 1) {
                stringBuffer.append("collapse-inner");
            } else {
                stringBuffer.append("collapse-outer");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

