/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.ObjectStreamException;
import org.apache.fop.traits.TraitEnum;

public final class Direction
extends TraitEnum {
    private static final long serialVersionUID = 1L;
    private static final String[] DIRECTION_NAMES = new String[]{"lr", "rl", "tb", "bt"};
    private static final int[] DIRECTION_VALUES = new int[]{201, 202, 203, 204};
    public static final Direction LR = new Direction(0);
    public static final Direction RL = new Direction(1);
    public static final Direction TB = new Direction(2);
    public static final Direction BT = new Direction(3);
    private static final Direction[] DIRECTIONS = new Direction[]{LR, RL, TB, BT};

    private Direction(int n) {
        super(DIRECTION_NAMES[n], DIRECTION_VALUES[n]);
    }

    public boolean isVertical() {
        return this.getEnumValue() == 203 || this.getEnumValue() == 204;
    }

    public boolean isHorizontal() {
        return this.getEnumValue() == 201 || this.getEnumValue() == 202;
    }

    public static Direction valueOf(String string) {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (!DIRECTIONS[i].getName().equalsIgnoreCase(string)) continue;
            return DIRECTIONS[i];
        }
        throw new IllegalArgumentException("Illegal direction: " + string);
    }

    public static Direction valueOf(int n) {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (DIRECTIONS[i].getEnumValue() != n) continue;
            return DIRECTIONS[i];
        }
        throw new IllegalArgumentException("Illegal direction: " + n);
    }

    private Object readResolve() throws ObjectStreamException {
        return Direction.valueOf(this.getName());
    }

    public String toString() {
        return this.getName();
    }
}

