/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

public class CharUtilities {
    public static final char CODE_EOT = '\u0000';
    public static final int UCWHITESPACE = 0;
    public static final int LINEFEED = 1;
    public static final int EOT = 2;
    public static final int NONWHITESPACE = 3;
    public static final int XMLWHITESPACE = 4;
    public static final char NULL_CHAR = '\u0000';
    public static final char LINEFEED_CHAR = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    public static final char NBSPACE = '\u00a0';
    public static final char NEXT_LINE = '\u0085';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char WORD_JOINER = '\u2060';
    public static final char ZERO_WIDTH_JOINER = '\u200d';
    public static final char LRM = '\u200e';
    public static final char RLM = '\u202f';
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    public static final char ZERO_WIDTH_NOBREAK_SPACE = '\ufeff';
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char LINE_SEPARATOR = '\u2028';
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char MISSING_IDEOGRAPH = '\u25a1';
    public static final char IDEOGRAPHIC_SPACE = '\u3000';
    public static final char OBJECT_REPLACEMENT_CHARACTER = '\ufffc';
    public static final char NOT_A_CHARACTER = '\uffff';

    protected CharUtilities() {
        throw new UnsupportedOperationException();
    }

    public static int classOf(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 10: {
                return 1;
            }
            case 9: 
            case 13: 
            case 32: {
                return 4;
            }
        }
        return CharUtilities.isAnySpace(n) ? 0 : 3;
    }

    public static boolean isBreakableSpace(int n) {
        return n == 32 || CharUtilities.isFixedWidthSpace(n);
    }

    public static boolean isZeroWidthSpace(int n) {
        return n == 8203 || n == 8288 || n == 65279;
    }

    public static boolean isFixedWidthSpace(int n) {
        return n >= 8192 && n <= 8203 || n == 12288;
    }

    public static boolean isNonBreakableSpace(int n) {
        return n == 160 || n == 8239 || n == 12288 || n == 8288 || n == 65279;
    }

    public static boolean isAdjustableSpace(int n) {
        return n == 32 || n == 160;
    }

    public static boolean isAnySpace(int n) {
        return CharUtilities.isBreakableSpace(n) || CharUtilities.isNonBreakableSpace(n);
    }

    public static boolean isAlphabetic(int n) {
        int n2 = Character.getType((char)n);
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static boolean isExplicitBreak(int n) {
        return n == 10 || n == 13 || n == 133 || n == 8232 || n == 8233;
    }

    public static String charToNCRef(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = n2 = n > 65535 ? 6 : 4;
        while (n3 < n2) {
            int n5 = n & 0xF;
            char c = n5 < 10 ? (char)(48 + n5) : (char)(65 + (n5 - 10));
            stringBuffer.append(c);
            ++n3;
            n >>= 4;
        }
        return "&#x" + stringBuffer.reverse() + ";";
    }

    public static String toNCRefs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ' && c < '\u007f') {
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(CharUtilities.charToNCRef(c));
            }
        }
        return stringBuffer.toString();
    }

    public static String padLeft(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String format(int n) {
        if (n < 0x110000) {
            return "0x" + CharUtilities.padLeft(Integer.toString(n, 16), n < 65536 ? 4 : 6, '0');
        }
        return "!NOT A CHARACTER!";
    }

    public static boolean isSameSequence(CharSequence charSequence, CharSequence charSequence2) {
        assert (charSequence != null);
        assert (charSequence2 != null);
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

