/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class ColorSpaceCache {
    private static Log log = LogFactory.getLog(ColorSpaceCache.class);
    private URIResolver resolver;
    private Map<String, ColorSpace> colorSpaceMap = Collections.synchronizedMap(new HashMap());

    public ColorSpaceCache(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public ColorSpace get(String string, String string2, String string3, RenderingIntent renderingIntent) {
        String string4 = string + ":" + string2 + string3;
        ColorSpace colorSpace = null;
        if (!this.colorSpaceMap.containsKey(string4)) {
            try {
                ICC_Profile iCC_Profile = null;
                Source source = this.resolver.resolve(string3, string2);
                if (source != null && source instanceof StreamSource) {
                    iCC_Profile = ColorProfileUtil.getICC_Profile((InputStream)((StreamSource)source).getInputStream());
                }
                if (iCC_Profile != null) {
                    colorSpace = new ICCColorSpaceWithIntent(iCC_Profile, renderingIntent, string, string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (colorSpace != null) {
                this.colorSpaceMap.put(string4, colorSpace);
            } else {
                log.warn((Object)("Color profile '" + string3 + "' not found."));
            }
        } else {
            colorSpace = this.colorSpaceMap.get(string4);
        }
        return colorSpace;
    }
}

