/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOM2SAX {
    private static final String EMPTYSTRING = "";
    private static final String XMLNS_PREFIX = "xmlns";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private Map prefixes = new HashMap();

    public DOM2SAX(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public void writeDocument(Document document, boolean bl) throws SAXException {
        if (!bl) {
            this.contentHandler.startDocument();
        }
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.writeNode(node);
        }
        if (!bl) {
            this.contentHandler.endDocument();
        }
    }

    public void writeFragment(Node node) throws SAXException {
        this.writeNode(node);
    }

    private boolean startPrefixMapping(String string, String string2) throws SAXException {
        boolean bl = true;
        Stack<String> stack = (Stack<String>)this.prefixes.get(string);
        if (stack != null) {
            if (stack.isEmpty()) {
                this.contentHandler.startPrefixMapping(string, string2);
                stack.push(string2);
            } else {
                String string3 = (String)stack.peek();
                if (!string3.equals(string2)) {
                    this.contentHandler.startPrefixMapping(string, string2);
                    stack.push(string2);
                } else {
                    bl = false;
                }
            }
        } else {
            this.contentHandler.startPrefixMapping(string, string2);
            stack = new Stack<String>();
            this.prefixes.put(string, stack);
            stack.push(string2);
        }
        return bl;
    }

    private void endPrefixMapping(String string) throws SAXException {
        Stack stack = (Stack)this.prefixes.get(string);
        if (stack != null) {
            this.contentHandler.endPrefixMapping(string);
            stack.pop();
        }
    }

    private static String getLocalName(Node node) {
        String string = node.getLocalName();
        if (string == null) {
            String string2 = node.getNodeName();
            int n = string2.lastIndexOf(58);
            return n > 0 ? string2.substring(n + 1) : string2;
        }
        return string;
    }

    private void writeNode(Node node) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                    this.contentHandler.characters(string.toCharArray(), 0, string.length());
                    this.lexicalHandler.endCDATA();
                    break;
                }
                this.contentHandler.characters(string.toCharArray(), 0, string.length());
                break;
            }
            case 8: {
                if (this.lexicalHandler == null) break;
                String string = node.getNodeValue();
                this.lexicalHandler.comment(string.toCharArray(), 0, string.length());
                break;
            }
            case 9: {
                this.contentHandler.startDocument();
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.writeNode(node2);
                }
                this.contentHandler.endDocument();
                break;
            }
            case 1: {
                String string;
                int n;
                String string2;
                String string3;
                Object object;
                int n2;
                ArrayList<String> arrayList = new ArrayList<String>();
                AttributesImpl attributesImpl = new AttributesImpl();
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n3 = namedNodeMap.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    object = namedNodeMap.item(n2);
                    string3 = object.getNodeName();
                    if (!string3.startsWith(XMLNS_PREFIX)) continue;
                    string2 = object.getNodeValue();
                    n = string3.lastIndexOf(58);
                    String string4 = string = n > 0 ? string3.substring(n + 1) : EMPTYSTRING;
                    if (!this.startPrefixMapping(string, string2)) continue;
                    arrayList.add(string);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    object = namedNodeMap.item(n2);
                    string3 = object.getNodeName();
                    if (string3.startsWith(XMLNS_PREFIX)) continue;
                    string2 = object.getNamespaceURI();
                    if (string2 != null) {
                        n = string3.lastIndexOf(58);
                        String string5 = string = n > 0 ? string3.substring(0, n) : EMPTYSTRING;
                        if (this.startPrefixMapping(string, string2)) {
                            arrayList.add(string);
                        }
                    }
                    attributesImpl.addAttribute(object.getNamespaceURI(), DOM2SAX.getLocalName((Node)object), string3, "CDATA", object.getNodeValue());
                }
                String string6 = node.getNodeName();
                object = node.getNamespaceURI();
                string3 = DOM2SAX.getLocalName(node);
                if (object != null) {
                    int n4 = string6.lastIndexOf(58);
                    String string7 = string = n4 > 0 ? string6.substring(0, n4) : EMPTYSTRING;
                    if (this.startPrefixMapping(string, (String)object)) {
                        arrayList.add(string);
                    }
                }
                this.contentHandler.startElement((String)object, string3, string6, attributesImpl);
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.writeNode(node3);
                }
                this.contentHandler.endElement((String)object, string3, string6);
                int n5 = arrayList.size();
                for (n = 0; n < n5; ++n) {
                    this.endPrefixMapping((String)arrayList.get(n));
                }
                break;
            }
            case 7: {
                this.contentHandler.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                String string = node.getNodeValue();
                this.contentHandler.characters(string.toCharArray(), 0, string.length());
                break;
            }
        }
    }
}

