/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util.text;

import java.util.Map;
import org.apache.fop.util.text.AdvancedMessageFormat;

public class HexFieldPart
implements AdvancedMessageFormat.Part {
    private String fieldName;

    public HexFieldPart(String string) {
        this.fieldName = string;
    }

    public boolean isGenerated(Map map) {
        Object v = map.get(this.fieldName);
        return v != null;
    }

    public void write(StringBuffer stringBuffer, Map map) {
        if (!map.containsKey(this.fieldName)) {
            throw new IllegalArgumentException("Message pattern contains unsupported field name: " + this.fieldName);
        }
        Object v = map.get(this.fieldName);
        if (v instanceof Character) {
            stringBuffer.append(Integer.toHexString(((Character)v).charValue()));
        } else if (v instanceof Number) {
            stringBuffer.append(Integer.toHexString(((Number)v).intValue()));
        } else {
            throw new IllegalArgumentException("Incompatible value for hex field part: " + v.getClass().getName());
        }
    }

    public String toString() {
        return "{" + this.fieldName + ",hex}";
    }

    public static class Factory
    implements AdvancedMessageFormat.PartFactory {
        public AdvancedMessageFormat.Part newPart(String string, String string2) {
            return new HexFieldPart(string);
        }

        public String getFormat() {
            return "hex";
        }
    }
}

