/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.product.util.ProductIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public class FunctionReferenceUtils {
    private FunctionReferenceUtils() {
    }

    public static List<Url> getAllReferencePageUrls(String string, boolean bl, boolean bl2) {
        List<ReferenceData> list = FunctionReferenceUtils.getReferenceData(string, FunctionReferenceUtils.getRefEntityTypes(bl));
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<Url> arrayList = new ArrayList<Url>();
        for (ReferenceData referenceData : list) {
            arrayList.add(FunctionReferenceUtils.getPageLocation(referenceData, bl2));
        }
        return arrayList;
    }

    public static Url getFullUrlForProduct(String string, String string2, boolean bl) {
        DocProduct docProduct = FunctionReferenceUtils.getDocProductByIndexString(string);
        if (docProduct == null) {
            return null;
        }
        return FunctionReferenceUtils.getPageLocation((DocSetItem)docProduct, string2, bl);
    }

    public static Url getPageLocation(ReferenceData referenceData, boolean bl) {
        return FunctionReferenceUtils.getPageLocation(referenceData.getDocSetItem(), referenceData.getRelativePath(), bl);
    }

    public static String getProductShortName(String string) {
        List<DocProduct> list = FunctionReferenceUtils.getAllDocProducts();
        if (list != null && !list.isEmpty()) {
            for (DocProduct docProduct : list) {
                if (!docProduct.getDisplayName().equalsIgnoreCase(string)) continue;
                return docProduct.getShortName();
            }
        }
        return null;
    }

    public static List<String> getInstalledProductShortNames(boolean bl) {
        Collection<DocProduct> collection = HelpPrefs.getInstalledDocProducts();
        ArrayList<String> arrayList = new ArrayList<String>();
        DocumentationSet documentationSet = FunctionReferenceUtils.getDocumentationSet();
        for (DocProduct docProduct : collection) {
            if (bl && !FunctionReferenceUtils.isInstalledDocProductSelected(docProduct, documentationSet)) continue;
            arrayList.add(FunctionReferenceUtils.getProductShortName(docProduct.getDisplayName()));
        }
        return arrayList;
    }

    public static List<FunctionProductData> getInstalledFunctionData(boolean bl) {
        Collection<DocProduct> collection = HelpPrefs.getInstalledDocProducts();
        ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
        DocumentationSet documentationSet = FunctionReferenceUtils.getDocumentationSet();
        for (DocProduct docProduct : collection) {
            if (bl && !FunctionReferenceUtils.isInstalledDocProductSelected(docProduct, documentationSet)) continue;
            arrayList.add(new DocCenterFunctionProductData(docProduct));
        }
        return arrayList;
    }

    public static String getLocalizedFilename(Url url) {
        return HelpUtils.getLocalizedFilename(url.toString());
    }

    public static List<FunctionProductData> getToplevelProductFunctionData() {
        Collection<ProductIdentifier> collection = HelpPrefs.getInstalledProducts();
        ArrayList<FunctionProductData> arrayList = new ArrayList<FunctionProductData>();
        for (ProductIdentifier productIdentifier : collection) {
            arrayList.add(new ProductIdentifierFunctionProductData(productIdentifier));
        }
        return arrayList;
    }

    private static DocumentationSet getDocumentationSet() {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        return docCenterDocConfig.getDocumentationSet();
    }

    private static boolean isInstalledDocProductSelected(DocProduct docProduct, DocumentationSet documentationSet) {
        return HelpPrefs.isInstalledDocProductSelected(docProduct, documentationSet);
    }

    private static List<DocProduct> getAllDocProducts() {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
        return documentationSet.getAllProducts();
    }

    private static DocProduct getDocProductByIndexString(String string) {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
        return documentationSet.getProductByShortName(string);
    }

    private static Url getPageLocation(DocSetItem docSetItem, String string, boolean bl) {
        Object object = bl ? DocCenterDocConfig.getLocalConfig().getDocRoot() : DocCenterDocConfig.getInstance().getDocRoot();
        return object.buildDocSetItemUrl(docSetItem, string);
    }

    private static Collection<RefEntityType> getRefEntityTypes(boolean bl) {
        EnumSet<RefEntityType> enumSet = EnumSet.of(RefEntityType.FUNCTION, RefEntityType.CLASS, RefEntityType.SYSTEM_OBJECT);
        if (bl) {
            enumSet.add(RefEntityType.METHOD);
            enumSet.add(RefEntityType.PROPERTY);
        }
        return enumSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReferenceData> getReferenceData(String string, Collection<RefEntityType> collection) {
        ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, collection);
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        try {
            List list = referenceDataRetriever.getReferenceData((ReferenceRequest)referenceEntityRequest);
            return list;
        }
        finally {
            try {
                referenceDataRetriever.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class DocCenterFunctionProductData
    implements FunctionProductData {
        private final DocProduct fDocProduct;

        public DocCenterFunctionProductData(DocProduct docProduct) {
            this.fDocProduct = docProduct;
        }

        @Override
        public String getShortName() {
            return this.fDocProduct.getShortName();
        }

        @Override
        public String getProductName() {
            return this.fDocProduct.getDisplayName();
        }

        @Override
        public boolean isSelected() {
            return HelpPrefs.isInstalledDocProductSelected(this.fDocProduct);
        }

        @Override
        public boolean hasRefPages() {
            return true;
        }
    }

    private static class ProductIdentifierFunctionProductData
    implements FunctionProductData {
        private final ProductIdentifier fProductIdentifier;

        public ProductIdentifierFunctionProductData(ProductIdentifier productIdentifier) {
            this.fProductIdentifier = productIdentifier;
        }

        @Override
        public String getShortName() {
            return this.fProductIdentifier.getName();
        }

        @Override
        public String getProductName() {
            return this.fProductIdentifier.getName();
        }

        @Override
        public boolean isSelected() {
            return HelpPrefs.isInstalledProductSelected(this.getProductName());
        }

        @Override
        public boolean hasRefPages() {
            return true;
        }
    }

    public static interface FunctionProductData {
        public String getShortName();

        public String getProductName();

        public boolean isSelected();

        public boolean hasRefPages();
    }
}

