/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;

public abstract class AbstractFormatToolsetSupplier
implements KeyListener,
MouseListener,
MouseMotionListener {
    protected Dimension fPreferredSize = new Dimension(170, 21);
    protected final ImageIcon fSpacerIcon = new ImageIcon(){

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    };

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.revertToCurrentFormat();
        } else if (n == 40 || n == 225) {
            this.handleKeyPress(true);
        } else if (n == 38 || n == 224) {
            this.handleKeyPress(false);
        }
    }

    abstract void handleKeyPress(boolean var1);

    abstract void revertToCurrentFormat();

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.showMousedOverFormat(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.revertToCurrentFormat();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.showMousedOverFormat(mouseEvent);
    }

    abstract void showMousedOverFormat(MouseEvent var1);

    protected class FormatDropDownButton
    extends TSDropDownButton {
        FormatDropDownButton(String string) {
            int n;
            super("Short");
            if (string.contains("&") && (n = string.indexOf(38)) + 2 <= string.length() - 1) {
                this.setButtonMnemonic(string.substring(n + 1, n + 2));
            }
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(this.isEnabled() ? Color.white : Color.lightGray);
            Rectangle rectangle = new Rectangle(0, 0, AbstractFormatToolsetSupplier.this.fPreferredSize.width, AbstractFormatToolsetSupplier.this.fPreferredSize.height);
            graphics2D.fill(rectangle);
            LAFUtil.paintDarkTriangle((Graphics2D)graphics2D, (int)((int)rectangle.getWidth() - 12), (int)10);
            graphics2D.setFont(ToolstripTheme.getInstance().getTSTextFieldFont());
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setColor(this.isEnabled() ? ToolstripTheme.getInstance().getButtonTextColor() : ToolstripTheme.getInstance().getButtonDisabledTextColor());
        }
    }
}

