/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.EditableValue;
import com.mathworks.mlwidgets.array.RefreshableVariableLiteral;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import com.mathworks.widgets.spreadsheet.IPrintingOpProvider;
import com.mathworks.widgets.spreadsheet.ISaveOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.print.MultiHeaderSpreadsheetPrinter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractMatlabTable
extends SpreadsheetTable
implements ISaveOpProvider,
IPrintingOpProvider,
EditableValue,
UpdatableData {
    private final MJAbstractAction fSaveAction;
    private final MJAbstractAction fPrintAction;
    private final MJAbstractAction fPrintSelectionAction;
    private final MJAbstractAction fPageSetupAction;
    protected final AbstractMatlabTableModel fAMTM;
    private boolean fUseMinimalMenus = false;
    private MouseAdapter fHeaderMouseListener;
    protected final int CELL_PADDING_SPACE = 20;
    private final int RESIZE_REGION = 4;

    protected AbstractMatlabTable(AbstractMatlabTableModel abstractMatlabTableModel) {
        super((TableModel)((Object)abstractMatlabTableModel));
        this.fAMTM = abstractMatlabTableModel;
        this.setScheme(0);
        TableActionProvider tableActionProvider = new TableActionProvider();
        this.fSaveAction = ArrayUtils.getSaveAction(abstractMatlabTableModel.getVariableName(), tableActionProvider);
        this.fPrintAction = new ArrayUtils.PrintAction(tableActionProvider);
        this.fPrintSelectionAction = new ArrayUtils.PrintSelectionAction(tableActionProvider);
        this.fPageSetupAction = new ArrayUtils.PageSetupAction(tableActionProvider);
        this.setHeaderMouseListener();
    }

    private void setHeaderMouseListener() {
        this.fHeaderMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AbstractMatlabTable.this.handleAutoResize(mouseEvent.getPoint());
                }
            }
        };
        this.getTableHeader().addMouseListener(this.fHeaderMouseListener);
    }

    WorkspaceVariable getVariable() {
        return this.fAMTM.getVariable();
    }

    public void setUseMinimalMenus(boolean bl) {
        this.fUseMinimalMenus = bl;
    }

    protected boolean useMinimalMenus() {
        return this.fUseMinimalMenus;
    }

    public String getVariableName() {
        return this.fAMTM.getVariableName();
    }

    public final Action getSaveAction() {
        return this.fSaveAction;
    }

    public final Action getPageSetupAction() {
        return this.fPageSetupAction;
    }

    public final Action getPrintAction() {
        return this.fPrintAction;
    }

    public final Action getPrintSelectionAction() {
        return this.fPrintSelectionAction;
    }

    @Override
    public void updateData() {
        this.fAMTM.updateData();
    }

    public void removeEmptyRows(int n) {
        int n2 = this.rowAtPoint(new Point(this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height));
        int n3 = n2 > n ? n2 : n;
        this.getSelectionModel().removeIndexInterval(n3 + 1, this.getRowCount() - 1);
        this.fAMTM.removeEmptyRows(n3);
    }

    public void removeEmptyColumns(int n) {
        int n2 = this.columnAtPoint(new Point(this.getVisibleRect().x + this.getVisibleRect().width, this.getVisibleRect().y));
        int n3 = n2 > n ? n2 : n;
        this.getColumnModel().getSelectionModel().removeIndexInterval(n3 + 1, this.getColumnCount() - 1);
        this.fAMTM.removeEmptyColumns(n3);
    }

    protected void setupSelectionAsPerSpreadsheet() {
        super.setupSelectionAsPerSpreadsheet();
        this.setSelectionMode(2);
        this.getColumnModel().getSelectionModel().setSelectionMode(2);
    }

    protected void populateClipboardFromIdentifier(VariableIdentifier variableIdentifier) {
        if (variableIdentifier.getVariable() != null || variableIdentifier.getExpression() != null) {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            RefreshableVariableLiteral.populateClipboardFromIdentifier(variableIdentifier, (ChangeListener)new SpreadsheetTable.CopyChangeListener((SpreadsheetTable)this, cursor));
        }
    }

    private static String getMainHeaderText(String string) {
        return ArrayUtils.getResource("printing.pageTitle", string) + "\t" + ArrayUtils.getResource("printing.header.pg") + " ";
    }

    public boolean isSortEnabledForSelection() {
        return this.isSortEnabledForSelection(this.getColumnModel());
    }

    protected boolean isSortEnabledForSelection(TableColumnModel tableColumnModel) {
        TableModel tableModel;
        int[] nArray;
        boolean bl = false;
        if (tableColumnModel.getSelectedColumnCount() > 0 && null != (nArray = this.restrictRowColumnSpecToValidRegion(tableColumnModel.getSelectedColumns(), 1)) && nArray.length > 0 && (tableModel = this.getModel()) instanceof IDataBoundsSupplier) {
            IDataBoundsSupplier iDataBoundsSupplier = (IDataBoundsSupplier)tableModel;
            int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
            int n = iDataBoundsSupplier.getLastDataRow() + 1;
            if ((this.getSelectedRows().length == this.getRowCount() || n == nArray2.length) && n > 1) {
                bl = true;
            }
        }
        return bl;
    }

    public void handleAutoResize(Point point) {
        if (this.getTableHeader().getCursor().getType() == 11) {
            Rectangle rectangle = this.getTableHeader().getVisibleRect();
            int n = this.getTableHeader().columnAtPoint(new Point(point.x - 8, point.y));
            this.handleAutoResize(n);
        }
    }

    public void handleAutoResize(int n) {
        int n2 = this.getColumnAutoSize(n);
        this.setColumnWidth(n, n2);
    }

    protected int getColumnAutoSize(int n) {
        int n2 = this.getMaxCellSizeInVisibleRange(n);
        return 20 + n2;
    }

    public void setColumnWidth(int n, int n2) {
        this.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    public int getMaxCellSizeInVisibleRange(int n) {
        Container container = this.getParent();
        Rectangle rectangle = container != null && container instanceof JViewport ? ((JComponent)container).getVisibleRect() : this.getVisibleRect();
        int n2 = rectangle.width / 2;
        int n3 = this.rowAtPoint(rectangle.getLocation());
        rectangle.translate(0, rectangle.height);
        int n4 = 1 + this.rowAtPoint(rectangle.getLocation());
        int n5 = this.getHeaderTitleWidth(this.getColumnModel().getColumn(n));
        return this.getMaxCellSizeHelper(n, n3, n4, n5, n2);
    }

    private int getMaxCellSizeHelper(int n, int n2, int n3, int n4, int n5) {
        Object object;
        int n6 = n4;
        for (int i = n2; i <= n3 && (object = this.getModel().getValueAt(i, n)) != null; ++i) {
            Component component = this.getCellRenderer(i, n).getTableCellRendererComponent((JTable)((Object)this), object, false, false, i, n);
            n6 = (int)Math.max((double)n6, component.getPreferredSize().getWidth());
        }
        if (n6 > n5) {
            return n5;
        }
        return n6;
    }

    private int getHeaderTitleWidth(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getTable().getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.getTableHeader().getTable(), tableColumn.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    private class TableActionProvider
    implements ArrayUtils.PrintActionProvider,
    ArrayUtils.SaveActionProvider {
        private TableActionProvider() {
        }

        @Override
        public void printSelection() {
            String string = AbstractMatlabTable.this.getVariableName();
            MultiHeaderSpreadsheetPrinter.printSelection((JTable)((Object)AbstractMatlabTable.this), (String)string, (String)AbstractMatlabTable.getMainHeaderText(string));
        }

        @Override
        public void print() {
            String string = AbstractMatlabTable.this.getVariableName();
            MultiHeaderSpreadsheetPrinter.print((JTable)((Object)AbstractMatlabTable.this), (String)string, (String)AbstractMatlabTable.getMainHeaderText(string), (Component)((Object)AbstractMatlabTable.this));
        }

        @Override
        public void pageSetup() {
            PrintUtils.showPageSetupDialog((String)ArrayUtils.getResource("printing.pageTitle"));
        }

        @Override
        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            AbstractMatlabTable.this.registerWithMapsUsingKeyBindingManager(mJAbstractAction);
        }

        @Override
        public Component getComponentForDialog() {
            return AbstractMatlabTable.this;
        }
    }
}

