/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ExtractVariableAction;
import com.mathworks.mlwidgets.array.ValueDataSection;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mvm.context.MvmContext;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.util.Log;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.spreadsheet.SpreadsheetPrefs;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import com.mathworks.widgets.spreadsheet.format.SupplementalFormatterFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public final class ArrayUtils {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.array.resources.RES_Array");
    private static boolean sLogging = false;
    private static Formatter CLIPBOARD_FORMATTER = FormatIdentifier.getDefaultInstance().getFormatter();
    private static Formatter sSystemClipboardFormatter;
    private static Setting<Boolean> sCodeGenEnabledKey;

    private ArrayUtils() {
    }

    public static String getResource(String string) {
        return BUNDLE.getString(string);
    }

    public static String getResource(String string, String string2) {
        return MessageFormat.format(ArrayUtils.getResource(string), string2);
    }

    public static String getCurrentStack(Object object) {
        String string = "Base";
        MatlabDebugServices.StackInfo stackInfo = MatlabDebugServices.createStackInfo((Object)object);
        if (stackInfo != null && (string = stackInfo.getWorkspaceNames()[stackInfo.getCurrentEntryIndex()]).equals("<Base>")) {
            string = "Base";
        }
        return string;
    }

    private static void refreshSystemClipboardFormatter() {
        sSystemClipboardFormatter = SupplementalFormatterFactory.getClipboardFormatter((char)SpreadsheetPrefs.getDecimalSeparator());
    }

    static String arrayToMatlabConstructor(TableModel tableModel, int n, boolean bl) {
        return ArrayUtils.createArrayConstructor(tableModel, n, bl, true);
    }

    static String arrayToTabbedConstructor(TableModel tableModel, int n, boolean bl) {
        return ArrayUtils.createArrayConstructor(tableModel, n, bl, false);
    }

    private static String createArrayConstructor(TableModel tableModel, int n, boolean bl, boolean bl2) {
        Serializable serializable;
        String string;
        String string2;
        String string3;
        char c;
        char c2;
        if (tableModel == null) {
            return null;
        }
        char c3 = c2 = bl2 ? (char)',' : '\t';
        if (SpreadsheetPrefs.getDecimalSeparator() == c2) {
            c2 = ' ';
        }
        char c4 = c = bl2 ? (char)';' : '\n';
        if (bl2) {
            string3 = n == 1 || n == 0 ? "{" : "[";
            string2 = n == 1 || n == 0 ? "}" : "]";
        } else {
            string3 = "";
            string2 = "";
        }
        if (bl && tableModel instanceof ValueTableModel && (string = ((ValueTableModel)(serializable = (ValueTableModel)tableModel)).getRODataForSection(0, 0)) != null) {
            if (string.endsWith("\n\n")) {
                string = string.substring(0, string.length() - 2);
            }
            return string3 + string.replace('\t', c2).replace('\n', c) + string2;
        }
        serializable = new StringBuilder(tableModel.getRowCount() * tableModel.getColumnCount() * 7);
        ((StringBuilder)serializable).append(string3);
        boolean bl3 = true;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (bl3) {
                bl3 = false;
            } else {
                ((StringBuilder)serializable).append(c);
            }
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                if (bl2) {
                    ((StringBuilder)serializable).append(ArrayUtils.replaceEscapeCharsWithMatlabCode(ArrayUtils.getValueQuotesString(tableModel, i, j, bl, bl2)));
                } else {
                    ((StringBuilder)serializable).append(ArrayUtils.getValueQuotesString(tableModel, i, j, bl, bl2));
                }
                if (j >= tableModel.getColumnCount() - 1) continue;
                ((StringBuilder)serializable).append(c2);
            }
        }
        ((StringBuilder)serializable).append(string2);
        return ((StringBuilder)serializable).toString();
    }

    private static String replaceEscapeCharsWithMatlabCode(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.replace("\r", "' char(13) '");
        string2 = string2.replace("\n", "' char(10) '");
        if ((string2 = string2.replace("\t", "' char(9) '")).length() != string.length()) {
            string2 = "[" + string2 + "]";
        }
        return string2;
    }

    private static String getValueQuotesString(TableModel tableModel, int n, int n2, boolean bl, boolean bl2) {
        Formatter formatter = bl2 ? CLIPBOARD_FORMATTER : sSystemClipboardFormatter;
        Object object = tableModel instanceof ValueTableModel ? ((ValueTableModel)tableModel).getValueAt(n, n2, bl, formatter) : tableModel.getValueAt(n, n2);
        if (object instanceof ValueDataSection) {
            return ((ValueDataSection)object).format(formatter, bl2);
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static void setLogging(boolean bl) {
        sLogging = bl;
    }

    public static boolean isLogging() {
        return sLogging;
    }

    public static void log(Class clazz, int n, String string) {
        ArrayUtils.log(clazz.getName(), n, string);
    }

    public static void log(String string, int n, String string2) {
        if (sLogging) {
            Log.printLn((String)(string + " : " + n + " : " + string2));
        }
    }

    @Deprecated
    public static void arrayViewAlert(Frame frame, String string) {
        ArrayDialog.showErrorDialog(string);
    }

    public static MJAbstractAction getSaveAction(String string, SaveActionProvider saveActionProvider) {
        return new SaveAction(string, saveActionProvider);
    }

    public static String getSelectionString(List<int[]> list, int n, List<int[]> list2, int n2) {
        if (list.size() == 1 && list2.size() == 1 && list.get(0)[0] == 0 && list.get(0)[1] == n - 1 && list2.get(0)[0] == 0 && list2.get(0)[1] == n2 - 1) {
            return "";
        }
        return SpreadsheetUtils.getSelectionString(list, (int)n) + "," + SpreadsheetUtils.getSelectionString(list2, (int)n2);
    }

    static List<int[]> getTruncatedIntervalList(List<int[]> list, int n) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n2 = 0;
        for (int[] nArray : list) {
            if (n <= n2) break;
            int n3 = nArray[1] - nArray[0] + 1;
            if (n3 + n2 > n) {
                nArray[1] = n - n2 + nArray[0] - 1;
            }
            arrayList.add(nArray);
            n2 = n2 + nArray[1] - nArray[0] + 1;
        }
        return arrayList;
    }

    private static Setting<Boolean> getCodeGenSetting() throws SettingException {
        if (!Matlab.isMatlabAvailable()) {
            return null;
        }
        if (sCodeGenEnabledKey == null) {
            SettingPath settingPath = new SettingPath(new SettingPath(MvmContext.get()), new String[]{"matlab", "desktop", "arrayeditor"});
            sCodeGenEnabledKey = new Setting(settingPath, Boolean.class, "CodeGenEnabled");
        }
        return sCodeGenEnabledKey;
    }

    static void addCodeGenerationSettingListener(SettingListener settingListener) {
        try {
            Setting<Boolean> setting = ArrayUtils.getCodeGenSetting();
            if (setting != null) {
                setting.addListener(settingListener);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    static void removeCodeGenerationSettingListener(SettingListener settingListener) {
        try {
            Setting<Boolean> setting = ArrayUtils.getCodeGenSetting();
            if (setting != null) {
                setting.removeListener(settingListener);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static boolean isCodeGenEnabled() {
        try {
            if (ArrayUtils.getCodeGenSetting() != null) {
                return (Boolean)ArrayUtils.getCodeGenSetting().get();
            }
            return true;
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static void setCodeGenEnabled(boolean bl) {
        try {
            ArrayUtils.getCodeGenSetting().set((Object)bl);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static String getUniqueMatlabVariableName(String string) {
        return ArrayUtils.getUniqueMatlabVariableName(string, "");
    }

    public static String getUniqueMatlabVariableName(String string, String string2) {
        String string3 = null;
        String string4 = ExtractVariableAction.getFieldName(string);
        try {
            String string5 = "";
            int n = 0;
            boolean bl = true;
            while (bl) {
                double[] dArray;
                Object object = Matlab.mtEval((String)("exist('" + string4 + string2 + string5 + "','var')"), (int)1);
                if (object instanceof double[] && (dArray = (double[])object).length == 1 && dArray[0] > 0.9 && dArray[0] < 1.1) {
                    bl = true;
                    string5 = Integer.toString(++n);
                    continue;
                }
                string3 = string4 + string2 + string5;
                bl = false;
            }
        }
        catch (Exception exception) {
            string3 = string4;
        }
        return string3;
    }

    static {
        if (Matlab.isMatlabAvailable()) {
            CLIPBOARD_FORMATTER = SupplementalFormatterFactory.getClipboardFormatter();
            sSystemClipboardFormatter = SupplementalFormatterFactory.getClipboardFormatter((char)SpreadsheetPrefs.getDecimalSeparator());
            Prefs.addListener((PrefListener)new ClipboardPrefListener(), (String)SpreadsheetPrefs.getDecimalSeparatorKey());
        } else {
            CLIPBOARD_FORMATTER = FormatIdentifier.getDefaultInstance().getFormatter();
            sSystemClipboardFormatter = FormatIdentifier.getDefaultInstance().getFormatter();
        }
        sCodeGenEnabledKey = null;
    }

    private static abstract class BasePrintAction
    extends BaseAction {
        private final PrintActionProvider fProvider;

        BasePrintAction(PrintActionProvider printActionProvider, String string, String string2) {
            super(string, string2);
            this.fProvider = printActionProvider;
            this.fProvider.registerWithInputAndActionMaps(this);
        }

        PrintActionProvider getProvider() {
            return this.fProvider;
        }
    }

    public static interface PrintActionProvider
    extends ActionProvider {
        public void printSelection();

        public void print();

        public void pageSetup();
    }

    static interface CreateVariableActionProvider
    extends ActionProvider {
        public VariableIdentifier getVariableIdentifier();
    }

    public static interface SaveActionProvider
    extends ActionProvider {
        public Component getComponentForDialog();
    }

    static interface ActionProvider {
        public void registerWithInputAndActionMaps(MJAbstractAction var1);
    }

    public static class PrintSelectionAction
    extends BasePrintAction {
        public PrintSelectionAction(PrintActionProvider printActionProvider) {
            super(printActionProvider, "print-selection", "PrintSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getProvider().printSelection();
        }
    }

    public static class PrintAction
    extends BasePrintAction {
        public PrintAction(PrintActionProvider printActionProvider) {
            super(printActionProvider, "print", "Print");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getProvider().print();
        }
    }

    public static class PageSetupAction
    extends BasePrintAction {
        public PageSetupAction(PrintActionProvider printActionProvider) {
            super(printActionProvider, "show-page-setup", "PageSetup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getProvider().pageSetup();
        }
    }

    public static class UpAction
    extends BaseAction {
        protected String fUpVarName;
        private final ActionListener fListener;

        public UpAction(String string) {
            this(string, (ActionListener)null);
        }

        public void setVariableName(String string) {
            this.fUpVarName = WorkspaceCommands.getImmediateParentIdentifier(string);
            this.setEnabled(this.fUpVarName != null);
        }

        public UpAction(String string, ActionListener actionListener) {
            super("variable-up-one-level", "GoUp");
            this.setVariableName(string);
            this.fListener = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fUpVarName != null) {
                if (this.fListener == null) {
                    WorkspaceCommands.openVariable(this.fUpVarName);
                } else {
                    this.fListener.actionPerformed(new ActionEvent((Object)this, 1001, this.fUpVarName));
                }
            }
        }
    }

    static class ExtractAction
    extends BaseAction {
        private final CreateVariableActionProvider fVarProvider;

        ExtractAction(CreateVariableActionProvider createVariableActionProvider) {
            super("create-variable-from-selection", "CreateVarFromSel");
            this.fVarProvider = createVariableActionProvider;
            this.fVarProvider.registerWithInputAndActionMaps(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VariableIdentifier variableIdentifier = this.fVarProvider.getVariableIdentifier();
            if (variableIdentifier != null) {
                String string = variableIdentifier.getVariable();
                if (string == null) {
                    string = variableIdentifier.getExpression();
                }
                if (string != null) {
                    if (MatlabDesktopServices.getDesktop().useToolstrip()) {
                        WorkspaceCommands.createAndOpenVariable(string);
                    } else {
                        WorkspaceCommands.createVariableUsingValue(string);
                    }
                }
            }
        }
    }

    static abstract class BaseAction
    extends MJAbstractAction {
        BaseAction(String string, String string2) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("VariableEditor", string, (ExtendedAction)this);
            this.setComponentName(string2);
        }
    }

    private static class SaveAction
    extends BaseAction {
        private final String iVariableName;
        private final SaveActionProvider iActionProvider;

        SaveAction(String string, SaveActionProvider saveActionProvider) {
            super("save-workspace", "Save");
            this.iVariableName = string;
            this.iActionProvider = saveActionProvider;
            this.setName(WorkspaceResources.getSaveWorkspaceLabel());
            this.iActionProvider.registerWithInputAndActionMaps(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = new String[]{this.iVariableName};
            WorkspaceCommands.saveVariables(stringArray, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.iActionProvider.getComponentForDialog()));
        }
    }

    private static class ClipboardPrefListener
    implements PrefListener {
        private ClipboardPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            ArrayUtils.refreshSystemClipboardFormatter();
        }
    }
}

