/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabObjectTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.spreadsheet.IAsynchronousContentAccessor;
import com.mathworks.widgets.spreadsheet.IMixedTypeDataHandler;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.util.ArrayList;
import java.util.List;

public class MatlabCellTableModel
extends AbstractMatlabObjectTableModel
implements IMixedTypeDataHandler,
IAsynchronousContentAccessor {
    public void printSetup(int n, int n2, int n3, int n4) {
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).printSetup(n, n2 > this.getLastDataRow() ? this.getLastDataRow() : n2, n3, n4 > this.getLastDataColumn() ? this.getLastDataColumn() : n4);
        }
    }

    public MatlabCellTableModel(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, true);
    }

    public MatlabCellTableModel(WorkspaceVariable workspaceVariable, boolean bl) {
        super(workspaceVariable, bl);
    }

    public MatlabCellTableModel(ValueTableModel valueTableModel, WorkspaceVariable workspaceVariable, boolean bl) {
        super(valueTableModel, workspaceVariable, bl);
    }

    public boolean areValuesSettable(int n, int n2, int n3, int n4) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object object2 = this.getValueAt(n, n2);
        if (object2 != null || !((String)object).trim().isEmpty()) {
            this.setCustomMessage(ArrayUtils.getResource("alert.SpecialCharEntryIncompatibilityCellArray"));
            this.setValueAt(object, n, n2, 0);
        }
    }

    public void setMixedTypeValueAt(Object object, int n, int n2) {
        this.setValueAt(object, n, n2, 1);
    }

    public void setValuesAt(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        String string;
        String string2 = string = PlatformInfo.isWindows() || PlatformInfo.isMacintosh() ? "cell.alert.PasteGeneralIncompatabilityExcel" : "cell.alert.PasteGeneralIncompatabilityTabbed";
        if (list.size() == 1 && list2.size() == 1) {
            this.setValuesAt(objectArray, list.get(0)[0], list2.get(0)[0]);
            return;
        }
        list = ArrayUtils.getTruncatedIntervalList(list, objectArray.length);
        list2 = ArrayUtils.getTruncatedIntervalList(list2, objectArray[0].length);
        this.setValuesAt(objectArray, list, list2, "assignmentPassthrough", false, ArrayUtils.getResource(string, MJUtilities.exciseAmpersand((String)SpreadsheetUtils.getPasteDataMenuResource())));
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2) {
        String string = PlatformInfo.isWindows() || PlatformInfo.isMacintosh() ? "cell.alert.PasteGeneralIncompatabilityExcel" : "cell.alert.PasteGeneralIncompatabilityTabbed";
        this.setValuesAt(objectArray, n, n2, "assignmentPassthrough", false, ArrayUtils.getResource(string, MJUtilities.exciseAmpersand((String)SpreadsheetUtils.getPasteDataMenuResource())));
    }

    public void setMixedTypeValuesAt(Object[][] objectArray, int n, int n2) {
        this.setValuesAt(objectArray, n, n2, "createSpreadsheetValues", true, ArrayUtils.getResource("cell.alert.PasteGeneralIncompatability"));
    }

    public void setMixedTypeValuesAt(Object[][] objectArray, List<int[]> list, List<int[]> list2) {
        this.setValuesAt(objectArray, list, list2, "createSpreadsheetValues", true, ArrayUtils.getResource("cell.alert.PasteGeneralIncompatability"));
    }

    void rename(String string) {
        this.setVariableName(string);
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).setVariableName(string);
        }
    }

    private void setValuesAt(Object[][] objectArray, int n, int n2, String string, boolean bl, String string2) {
        if (objectArray.length > 0 && objectArray[0].length > 0) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            arrayList.add(new int[]{n, n});
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            arrayList2.add(new int[]{n2, n2});
            new SetValuesAtDoer(this.getVariable(), objectArray, arrayList, arrayList2, string, bl, string2, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
        }
    }

    private void setValuesAt(Object[][] objectArray, List<int[]> list, List<int[]> list2, String string, boolean bl, String string2) {
        if (objectArray.length > 0 && objectArray[0].length > 0) {
            new SetValuesAtDoer(this.getVariable(), objectArray, list, list2, string, bl, string2, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
        }
    }

    public void setValueMetaInfo(ValueMetaInfo valueMetaInfo) {
        ((ValueTableModel)this.fModel).setValueMetaInfo(valueMetaInfo);
    }

    @Override
    protected String getEmptyValueConstructor() {
        return "{[]}";
    }

    @Override
    protected String getIndexingOpenToken() {
        return "{";
    }

    @Override
    protected String getIndexingCloseToken() {
        return "}";
    }

    private class SetValuesAtUndoer
    extends SetValuesAtRunnable {
        SetValuesAtUndoer(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, String string, boolean bl, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, objectArray, list, list2, string, bl, string2, undoKey);
        }

        private void runDefaultWorkspace() {
            MatlabCellTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, MatlabCellTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(MatlabCellTableModel.this.fUndoManager));
        }

        private void runNonDefaultWorkspace() {
            MatlabCellTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"undo", this.iVariable, this.iKey.stringValue()}, 0, (CompletionObserver)new UndoerCompletionObserver(MatlabCellTableModel.this.fUndoManager));
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 2, "multiple values, " + this.iRowIntervals + ", " + this.iColumnIntervals + ", " + this.iType + ", " + this.iQuotify + ", " + this.iErrorMessage);
            }
            if (MatlabCellTableModel.this.fUndoManager != null) {
                MatlabCellTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtDoer(this.iVariable, this.iValues, this.iRowIntervals, this.iColumnIntervals, this.iType, this.iQuotify, this.iErrorMessage, this.iKey);
        }
    }

    private class SetValuesAtDoer
    extends SetValuesAtRunnable {
        SetValuesAtDoer(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, String string, boolean bl, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            super(workspaceVariable, objectArray, list, list2, string, bl, string2, undoKey);
        }

        private void runDefaultWorkspace() {
            int n = this.iValues.length;
            int n2 = this.iValues[0].length;
            StringBuilder stringBuilder = new StringBuilder("arrayviewfunc('" + this.iType + "', " + MatlabCellTableModel.this.getIndexingOpenToken());
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    String string = this.iValues[i][j].toString();
                    if (string.trim().length() != 0) {
                        if (this.iQuotify) {
                            stringBuilder.append('\'').append(StringUtils.quoteSingleQuotes((String)string)).append('\'');
                        } else {
                            stringBuilder.append(string);
                        }
                    } else {
                        stringBuilder.append("[]");
                    }
                    stringBuilder.append(", ");
                }
                stringBuilder.append("; ");
            }
            stringBuilder.append(MatlabCellTableModel.this.getIndexingCloseToken()).append(");");
            StringBuilder stringBuilder2 = this.iRowIntervals.size() == 1 && this.iColumnIntervals.size() == 1 ? MatlabCellTableModel.this.constructIndexingExpression(((int[])this.iRowIntervals.get(0))[0] + 1, ((int[])this.iRowIntervals.get(0))[0] + n, ((int[])this.iColumnIntervals.get(0))[0] + 1, ((int[])this.iColumnIntervals.get(0))[0] + n2, "(", ")") : MatlabCellTableModel.this.constructIndexingExpression(this.iRowIntervals, this.iColumnIntervals, "(", ")");
            stringBuilder2.append(" = ").append((CharSequence)stringBuilder).append(';');
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 3, stringBuilder2.toString());
            }
            MatlabCellTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getStorageString(this.iKey, MatlabCellTableModel.this.getVariableName()) + stringBuilder2, MatlabCellTableModel.this.getRefreshErrorDialogCO(this.iErrorMessage, new DoerCompletionObserver(this, MatlabCellTableModel.this.fUndoManager)));
        }

        private void runNonDefaultWorkspace() {
            int n;
            boolean bl;
            if (this.iType.equals("assignmentPassthrough")) {
                bl = true;
            } else if (this.iType.equals("createSpreadsheetValues")) {
                bl = false;
            } else {
                bl = true;
                assert (false) : "Unrecognized type " + this.iType;
            }
            for (int[] nArray : this.iRowIntervals) {
                n = 0;
                while (n < nArray.length) {
                    int n2 = n++;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
            for (int[] nArray : this.iColumnIntervals) {
                n = 0;
                while (n < nArray.length) {
                    int n3 = n++;
                    nArray[n3] = nArray[n3] + 1;
                }
            }
            MatlabCellTableModel.this.getUserActionMCR().feval("arrayviewfunc", new Object[]{"matmSetValuesAt", this.iVariable, this.iKey.stringValue(), this.iValues, this.iRowIntervals, this.iColumnIntervals, bl}, 0, MatlabCellTableModel.this.getRefreshErrorDialogCOForFeval(ArrayUtils.getResource("alert.PasteGeneralIncompatability"), new DoerCompletionObserver(this, MatlabCellTableModel.this.fUndoManager)));
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, "multiple values, " + this.iRowIntervals + ", " + this.iColumnIntervals + ", " + this.iType + ", " + this.iQuotify + ", " + this.iErrorMessage);
            }
            if (MatlabCellTableModel.this.fUndoManager != null) {
                MatlabCellTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtUndoer(this.iVariable, this.iValues, this.iRowIntervals, this.iColumnIntervals, this.iType, this.iQuotify, this.iErrorMessage, this.iKey);
        }
    }

    private static abstract class SetValuesAtRunnable
    implements InvertableRunnable {
        protected WorkspaceVariable iVariable;
        protected Object[][] iValues;
        protected List<int[]> iRowIntervals;
        protected List<int[]> iColumnIntervals;
        protected String iType;
        protected boolean iQuotify;
        protected String iErrorMessage;
        protected WorkspaceUndoManager.UndoKey iKey;

        private void assignValues(Object[][] objectArray) {
            if (objectArray == null) {
                this.iValues = objectArray;
            } else {
                int n = objectArray.length;
                int n2 = objectArray[0].length;
                this.iValues = new Object[n][n2];
                for (int i = 0; i < n; ++i) {
                    Object[] objectArray2 = new Object[n2];
                    this.iValues[i] = objectArray2;
                    System.arraycopy(objectArray[i], 0, objectArray2, 0, n2);
                }
            }
        }

        SetValuesAtRunnable(WorkspaceVariable workspaceVariable, Object[][] objectArray, List<int[]> list, List<int[]> list2, String string, boolean bl, String string2, WorkspaceUndoManager.UndoKey undoKey) {
            assert (workspaceVariable != null);
            this.iVariable = workspaceVariable;
            this.assignValues(objectArray);
            this.iRowIntervals = new ArrayList<int[]>(list);
            this.iColumnIntervals = new ArrayList<int[]>(list2);
            this.iType = string;
            this.iQuotify = bl;
            this.iErrorMessage = string2;
            this.iKey = undoKey;
        }
    }
}

