/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractMatlabObjectTableModel;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueTableModel;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.widgets.spreadsheet.IBlockValueSetter;

public class MatlabObjArrayTableModel
extends AbstractMatlabObjectTableModel
implements IBlockValueSetter {
    public MatlabObjArrayTableModel(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, true);
    }

    public MatlabObjArrayTableModel(WorkspaceVariable workspaceVariable, boolean bl) {
        super(workspaceVariable, bl);
    }

    protected MatlabObjArrayTableModel(ValueTableModel valueTableModel, WorkspaceVariable workspaceVariable) {
        super(valueTableModel, workspaceVariable, false);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.setCustomMessage(ArrayUtils.getResource("alert.SpecialCharEntryIncompatibilityStructArray"));
        this.setValueAt(object, n, n2, 0);
    }

    public boolean areValuesSettable(int n, int n2, int n3, int n4) {
        return true;
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2) {
        if (objectArray.length > 0 && objectArray[0].length > 0) {
            new SetValuesAtDoer(objectArray, n, n2, WorkspaceUndoManager.getNewKey(this.fUndoManager)).run();
        }
    }

    void rename(String string) {
        this.setVariableName(string);
        if (this.fModel instanceof ValueTableModel) {
            ((ValueTableModel)this.fModel).setVariableName(string);
        }
    }

    @Override
    protected String getEmptyValueConstructor() {
        return "[]";
    }

    @Override
    protected String getIndexingOpenToken() {
        return "(";
    }

    @Override
    protected String getIndexingCloseToken() {
        return ")";
    }

    private class SetValuesAtUndoer
    extends SetValuesAtRunnable {
        SetValuesAtUndoer(Object[][] objectArray, int n, int n2, WorkspaceUndoManager.UndoKey undoKey) {
            super(objectArray, n, n2, undoKey);
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 2, "multiple values, " + this.iRow + ", " + this.iColumn);
            }
            if (MatlabObjArrayTableModel.this.fUndoManager != null) {
                MatlabObjArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            MatlabObjArrayTableModel.this.getUserActionMCR().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, MatlabObjArrayTableModel.this.getVariableName()), (CompletionObserver)new UndoerCompletionObserver(MatlabObjArrayTableModel.this.fUndoManager));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtDoer(this.iValues, this.iRow, this.iColumn, this.iKey);
        }
    }

    private class SetValuesAtDoer
    extends SetValuesAtRunnable {
        SetValuesAtDoer(Object[][] objectArray, int n, int n2, WorkspaceUndoManager.UndoKey undoKey) {
            super(objectArray, n, n2, undoKey);
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, "multiple values, " + this.iRow + ", " + this.iColumn);
            }
            if (MatlabObjArrayTableModel.this.fUndoManager != null) {
                MatlabObjArrayTableModel.this.fUndoManager.receiveNextUndoableEdit();
            }
            int n = this.iValues.length;
            int n2 = this.iValues[0].length;
            StringBuilder stringBuilder = new StringBuilder(MatlabObjArrayTableModel.this.constructIndexingExpression(this.iRow + n - 1 + 1, this.iRow + n2 - 1 + 1) + " = 0;");
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Object object = this.iValues[i][j];
                    if (object.equals(MatlabObjArrayTableModel.this.getValueAt(this.iRow + i, this.iColumn + j))) continue;
                    stringBuilder.append((CharSequence)MatlabObjArrayTableModel.this.constructIndexingExpression(this.iRow + i + 1, this.iColumn + j + 1)).append(" = ").append(object).append("; ");
                }
            }
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 2, stringBuilder.toString());
            }
            MatlabObjArrayTableModel.this.getUserActionMCR().eval(stringBuilder.toString(), MatlabObjArrayTableModel.this.getRefreshErrorDialogCO(null, new DoerCompletionObserver(this, MatlabObjArrayTableModel.this.fUndoManager)));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtUndoer(this.iValues, this.iRow, this.iColumn, this.iKey);
        }
    }

    private static abstract class SetValuesAtRunnable
    implements InvertableRunnable {
        protected Object[][] iValues;
        protected int iRow;
        protected int iColumn;
        protected WorkspaceUndoManager.UndoKey iKey;

        SetValuesAtRunnable(Object[][] objectArray, int n, int n2, WorkspaceUndoManager.UndoKey undoKey) {
            this.iValues = objectArray != null ? (Object[][])objectArray.clone() : (Object[][])null;
            this.iRow = n;
            this.iColumn = n2;
            this.iKey = undoKey;
        }
    }
}

