/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.StructArrayTable;
import com.mathworks.mlwidgets.array.TabularObjectHeaderRenderer;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mlwidgets.workspace.util.WorkspaceIcon;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;

public class StructArrayHeaderRenderer
extends TabularObjectHeaderRenderer {
    private static final int BORDER_OFFSET = 5;
    private static final int WORKSPACE_ICON_WIDTH = WorkspaceIcon.getNumericIcon().getIconWidth();
    private static ImageIcon sMixedDataIcon;

    public StructArrayHeaderRenderer(TabularObjectTable tabularObjectTable, TabularObjectHeaderRenderer.Alignment alignment) {
        super((JTable)((Object)tabularObjectTable), alignment, false, false);
        this.fNameTextField.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.fPanel = new MJPanel();
        if (alignment == TabularObjectHeaderRenderer.Alignment.ROWS) {
            this.fLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 30));
        } else {
            this.fPanel.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.fPanel.add((Component)this.fLabel, (Object)gridBagConstraints);
            gridBagConstraints.gridx = 1;
            StructArrayHeaderRenderer.addNameFieldToPanel(gridBagConstraints, this.fPanel, this.fNameTextField);
            this.fEditorPanel.setLayout((LayoutManager)new GridBagLayout());
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            StructArrayHeaderRenderer.addNameFieldToPanel(gridBagConstraints2, this.fEditorPanel, this.fNameEditField);
            sMixedDataIcon = new ImageIcon(this.getClass().getResource("/com/mathworks/mlwidgets/array/resources/variable_mixed.png"));
        }
    }

    private static void addNameFieldToPanel(GridBagConstraints gridBagConstraints, MJPanel mJPanel, MJTextField mJTextField) {
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        mJPanel.add((Component)mJTextField, (Object)gridBagConstraints);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = this.fDropArrowColumn == n2;
        this.showArrow(bl3);
        this.setLabelState(this.fTable.isColumnSelected(n2));
        if (object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) {
            TabularObjectHeaderRenderer.NamedHeaderContent namedHeaderContent = (TabularObjectHeaderRenderer.NamedHeaderContent)object;
            this.fNameTextField.setText(namedHeaderContent.getName());
            String string = ((StructArrayTable)((Object)this.fTable)).getVariableMatlabClass(n2);
            if (string != null && string.equals("mixed")) {
                this.fLabel.setIcon(sMixedDataIcon);
            } else {
                this.fLabel.setIcon(WorkspaceIcon.getIcon(string));
            }
        } else {
            this.fNameTextField.setText("");
            this.fLabel.setIcon(null);
        }
        this.fPanel.revalidate();
        return this.fPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof TabularObjectHeaderRenderer.NamedHeaderContent) {
            this.fNameEditField.setText(((TabularObjectHeaderRenderer.NamedHeaderContent)object).getName());
            this.fNameEditField.setName("NameEditField" + Integer.toString(n2));
            this.fEditorLabel.setName(((TabularObjectHeaderRenderer.NamedHeaderContent)object).getRowID());
            this.fEditorPanel.revalidate();
            this.fEditorPanel.repaint();
            this.fNameEditField.selectAll();
            return this.fEditorPanel;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        String string = this.fEditorLabel.getName();
        int n = string != null ? Integer.parseInt(string) : -1;
        return new TabularObjectHeaderRenderer.NamedHeaderContent(n, this.fNameEditField.getText());
    }

    @Override
    public int getGripIconWidth() {
        return WORKSPACE_ICON_WIDTH;
    }
}

