/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.GroupHeaderUI;
import com.mathworks.mlwidgets.array.TabularObjectColumnModel;
import com.mathworks.mlwidgets.array.TabularObjectTable;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.HeaderBorder;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.Nullable;

class TabularObjectHeaderRenderer
extends AbstractCellEditor
implements IHeaderRenderer,
TableCellEditor {
    protected MJPanel fPanel;
    protected final MJTextField fNameTextField;
    protected JLabel fLabel = null;
    protected final JLabel fEditorLabel;
    protected final MJTextField fNameEditField;
    protected final MJPanel fEditorPanel;
    private Font fLabelFont;
    protected JTable fTable = null;
    private SpreadsheetColor fSpreadsheetColor = null;
    private final Border fBorderUnselected;
    private Alignment fAlignment = Alignment.ROWS;
    protected int fDropArrowColumn = -1;
    private int fHoverColumn = -1;
    private static final ImageIcon GRIP_ICON = new ImageIcon(GroupHeaderUI.class.getResource("/com/mathworks/mlwidgets/array/resources/grip.png"));
    private static final ImageIcon ARROW_ICON = new ImageIcon(GroupHeaderUI.class.getResource("/com/mathworks/mlwidgets/array/resources/menuarrow.png"));
    private static final ImageIcon CURRENT_GRIP_ICON = GRIP_ICON;
    public static final int DEFAULT_HORIZONTAL_GAP = 5;
    private static Color sRowHeaderColorSelected = new Color(200, 200, 200);
    private static Color sRowHeaderColorUnselected = new Color(241, 242, 244);
    private static Color sRowHeaderForegroundColorSelected = Color.black;
    private static Color sRowHeaderForegroundColorUnselected = Color.black;

    private static void setHighContrast(boolean bl) {
        if (bl) {
            sRowHeaderColorSelected = Color.white;
            sRowHeaderColorUnselected = Color.black;
            sRowHeaderForegroundColorSelected = Color.black;
            sRowHeaderForegroundColorUnselected = Color.white;
        } else {
            sRowHeaderColorSelected = new Color(200, 200, 200);
            sRowHeaderColorUnselected = new Color(241, 242, 244);
            sRowHeaderForegroundColorSelected = Color.black;
            sRowHeaderForegroundColorUnselected = Color.black;
        }
    }

    TabularObjectHeaderRenderer(JTable jTable, Alignment alignment) {
        this(jTable, alignment, true, false);
    }

    TabularObjectHeaderRenderer(JTable jTable, Alignment alignment, boolean bl, boolean bl2) {
        this.fTable = jTable;
        this.fAlignment = alignment;
        this.fSpreadsheetColor = new SpreadsheetColor((JTable)(jTable == null ? new MJTable() : jTable));
        this.fSpreadsheetColor.registerColorInterests();
        this.fLabel = new MJLabel("", 2);
        this.fEditorLabel = new MJLabel("", 2);
        this.fBorderUnselected = new HeaderBorder(this.fSpreadsheetColor.getHeaderUnselectedLine());
        this.fPanel = new DropDownPanel(new BorderLayout(5, 0), bl);
        this.fNameTextField = new MJTextField();
        this.fNameTextField.setEditable(false);
        this.fNameTextField.setBorder(null);
        this.fNameEditField = new MJTextField();
        this.fEditorPanel = new MJPanel(new BorderLayout(5, 0)){

            public void requestFocus() {
                TabularObjectHeaderRenderer.this.fNameEditField.requestFocus();
                TabularObjectHeaderRenderer.this.fNameEditField.selectAll();
            }
        };
        this.fNameEditField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    TabularObjectHeaderRenderer.this.fireEditingStopped();
                }
            }
        });
        this.fNameEditField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabularObjectHeaderRenderer.this.fireEditingStopped();
            }
        });
        if (this.fTable instanceof TabularObjectTable) {
            this.fNameEditField.getActionMap().put("undo", ((IUndoOpProvider)this.fTable).getUndoAction());
            if (PlatformInfo.isWindows()) {
                this.fNameEditField.getInputMap().put(KeyStroke.getKeyStroke(90, 128), "undo");
            } else if (PlatformInfo.isMacintosh()) {
                this.fNameEditField.getInputMap().put(KeyStroke.getKeyStroke(90, 256), "undo");
            } else if (PlatformInfo.isLinux()) {
                this.fNameEditField.getInputMap().put(KeyStroke.getKeyStroke(45, 192), "undo");
            }
        }
        this.fNameEditField.setBorder(null);
        if (alignment == Alignment.ROWS) {
            if (bl2) {
                int n = this.fLabel.getFontMetrics(this.fLabel.getFont()).stringWidth(ArrayUtils.getResource("structureArray.fieldsLabel"));
                this.fLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, n + 10));
            }
            this.fLabel.setHorizontalAlignment(4);
            this.fLabel.setHorizontalTextPosition(4);
            this.fPanel.add((Component)this.fLabel, (Object)"West");
            this.fNameTextField.setHorizontalAlignment(2);
            this.fPanel.add((Component)this.fNameTextField, (Object)"Center");
            this.fEditorLabel.setHorizontalAlignment(4);
            this.fEditorLabel.setHorizontalTextPosition(4);
            this.fEditorPanel.add((Component)this.fEditorLabel, (Object)"West");
            this.fNameEditField.setHorizontalAlignment(2);
            this.fEditorPanel.add((Component)this.fNameEditField, (Object)"Center");
        } else {
            this.fLabel.setHorizontalAlignment(0);
            this.fLabel.setHorizontalTextPosition(0);
            this.fPanel.add((Component)this.fLabel, (Object)"North");
            this.fNameTextField.setHorizontalAlignment(0);
            this.fPanel.add((Component)this.fNameTextField, (Object)"South");
            this.setupColumnEditor();
        }
    }

    protected void setupColumnEditor() {
        this.fEditorLabel.setHorizontalAlignment(0);
        this.fEditorLabel.setHorizontalTextPosition(0);
        this.fEditorPanel.add((Component)this.fEditorLabel, (Object)"North");
        this.fNameEditField.setHorizontalAlignment(0);
        this.fEditorPanel.add((Component)this.fNameEditField, (Object)"South");
    }

    public static int getIconWidths() {
        return CURRENT_GRIP_ICON.getIconWidth() + ARROW_ICON.getIconWidth();
    }

    public int getGripIconWidth() {
        return CURRENT_GRIP_ICON.getIconWidth();
    }

    boolean isEditableAtPoint(Point point, int n, Object object) {
        assert (this.fAlignment == Alignment.COLUMNS);
        if (this.isHeaderEditing()) {
            return false;
        }
        this.getTableCellEditorComponent(null, object, true, 0, n);
        return point.y > this.fNameTextField.getBounds().y;
    }

    void setDropArrowColumn(int n) {
        assert (this.fAlignment == Alignment.COLUMNS);
        this.fDropArrowColumn = n;
    }

    int getDropArrowColumn() {
        assert (this.fAlignment == Alignment.COLUMNS);
        return this.fDropArrowColumn;
    }

    void setHoverColumn(int n) {
        assert (this.fAlignment == Alignment.COLUMNS);
        this.fHoverColumn = n;
    }

    int getHoverColumn() {
        assert (this.fAlignment == Alignment.COLUMNS);
        return this.fHoverColumn;
    }

    boolean isHeaderEditing() {
        assert (this.fAlignment == Alignment.COLUMNS);
        return SwingUtilities.isDescendingFrom((Component)this.fEditorPanel, this.fTable.getTableHeader());
    }

    @Override
    public void fireEditingStopped() {
        if (this.fAlignment == Alignment.COLUMNS) {
            this.fTable.getTableHeader().remove((Component)this.fEditorPanel);
            this.fTable.getTableHeader().revalidate();
            this.fTable.getTableHeader().repaint();
        }
        super.fireEditingStopped();
    }

    @Override
    public void cancelCellEditing() {
        if (this.fAlignment == Alignment.COLUMNS) {
            this.fTable.getTableHeader().remove((Component)this.fEditorPanel);
            this.fTable.getTableHeader().revalidate();
            this.fTable.getTableHeader().repaint();
        }
        super.cancelCellEditing();
    }

    boolean editColumnHeaderCellAt(JTable jTable, int n) {
        Component component;
        if (!(jTable.getColumnModel() instanceof TabularObjectColumnModel)) {
            return false;
        }
        TabularObjectColumnModel tabularObjectColumnModel = (TabularObjectColumnModel)jTable.getColumnModel();
        if (n >= tabularObjectColumnModel.getVariableColumnCount()) {
            return false;
        }
        if (tabularObjectColumnModel.isSpanningColumn(n)) {
            int[] nArray = ((TabularObjectColumnModel)jTable.getColumnModel()).getGroupColumnInterval(n);
            Object object = jTable.getColumnModel().getColumn(nArray[0]).getHeaderValue();
            Rectangle rectangle = jTable.getTableHeader().getHeaderRect(nArray[0]).union(jTable.getTableHeader().getHeaderRect(nArray[1] - 1));
            component = this.getTableCellEditorComponent(jTable, object, true, 0, n);
            component.setBounds(rectangle);
        } else {
            Object object = jTable.getColumnModel().getColumn(n).getHeaderValue();
            component = this.getTableCellEditorComponent(jTable, object, true, 0, n);
            component.setBounds(jTable.getTableHeader().getHeaderRect(n));
        }
        jTable.getTableHeader().add(component);
        component.validate();
        component.repaint();
        component.requestFocus();
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return this.fTable.getColumnModel().getSelectionModel().getMinSelectionIndex() == 0 && this.fTable.getColumnModel().getSelectionModel().getMaxSelectionIndex() == this.fTable.getColumnCount() - 1;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTable jTable2 = jTable;
        if (this.fTable != null) {
            jTable2 = this.fTable;
        }
        if (this.fAlignment == Alignment.ROWS) {
            this.setLabelState(jTable2.isRowSelected(n));
        } else {
            this.setLabelState(jTable2.isColumnSelected(n2));
        }
        boolean bl3 = this.fAlignment == Alignment.COLUMNS && this.fDropArrowColumn == n2 && object instanceof NamedHeaderContent;
        this.showArrow(bl3);
        if (this.fPanel instanceof DropDownPanel) {
            ((DropDownPanel)this.fPanel).showHover(this.fHoverColumn == n2);
        }
        if (object instanceof NamedHeaderContent) {
            NamedHeaderContent namedHeaderContent = (NamedHeaderContent)object;
            this.fLabel.setText(namedHeaderContent.getRowID());
            this.fNameTextField.setText(namedHeaderContent.getName());
        } else {
            this.fLabel.setText(object.toString());
            this.fNameTextField.setText("");
        }
        this.fPanel.revalidate();
        return this.fPanel;
    }

    void showArrow(boolean bl) {
        if (this.fPanel instanceof DropDownPanel) {
            ((DropDownPanel)this.fPanel).showArrow(bl);
        }
    }

    @Override
    public Component getTableCellEditorComponent(@Nullable JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object instanceof NamedHeaderContent) {
            this.fNameEditField.setText(((NamedHeaderContent)object).getName());
            this.fNameEditField.setName("NameEditField" + Integer.toString(n2));
            this.fEditorLabel.setText(((NamedHeaderContent)object).getRowID());
            this.fEditorPanel.revalidate();
            this.fEditorPanel.repaint();
            this.fNameEditField.selectAll();
            return this.fEditorPanel;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return new NamedHeaderContent(Integer.parseInt(this.fEditorLabel.getText()), this.fNameEditField.getText());
    }

    void setBackground(Color color) {
        this.fLabel.setBackground(color);
        if (this.fPanel != null) {
            this.fNameTextField.setBackground(color);
            this.fPanel.setBackground(color);
        }
    }

    void setForeground(Color color) {
        this.fLabel.setBackground(color);
        if (this.fPanel != null) {
            this.fNameTextField.setForeground(color);
            this.fPanel.setForeground(color);
        }
    }

    public int getPreferredWidth(FontMetrics fontMetrics, Object object) {
        Component component = this.getTableCellRendererComponent(this.fTable, object, false, false, 0, 0);
        return component.getPreferredSize().width + 5;
    }

    public void setFont(Font font) {
        this.fLabel.setFont(font);
        if (this.fPanel != null) {
            this.fNameTextField.setFont(font);
            this.fPanel.revalidate();
        }
    }

    void setBorder(Border border) {
        if (this.fPanel != null) {
            this.fPanel.setBorder(border);
        }
    }

    protected void setLabelState(boolean bl) {
        Font font = this.fLabel.getFont();
        if (!font.equals(this.fLabelFont)) {
            this.fLabelFont = font;
        }
        if (bl) {
            this.setForeground(this.fSpreadsheetColor.getHeaderSelectedForeground());
            this.setBackground(sRowHeaderColorSelected);
            this.fLabel.setBackground(sRowHeaderColorSelected);
            this.fLabel.setForeground(sRowHeaderForegroundColorSelected);
            this.fNameTextField.setForeground(sRowHeaderForegroundColorSelected);
        } else {
            this.setBorder(this.fBorderUnselected);
            this.setForeground(this.fSpreadsheetColor.getHeaderUnselectedForeground());
            this.setBackground(sRowHeaderColorUnselected);
            this.fLabel.setBackground(sRowHeaderColorUnselected);
            this.fLabel.setForeground(sRowHeaderForegroundColorUnselected);
            this.fNameTextField.setForeground(sRowHeaderForegroundColorUnselected);
        }
    }

    public Color getPreferredGridColor() {
        return this.fSpreadsheetColor.getHeaderUnselectedLine();
    }

    public void cleanup() {
        this.fSpreadsheetColor.setBaseTable(null);
        this.fSpreadsheetColor.unregisterColorInterests();
        this.fSpreadsheetColor = null;
    }

    static {
        if (MJUtilities.isHighContrast()) {
            TabularObjectHeaderRenderer.setHighContrast(true);
        }
    }

    static class DropDownPanel
    extends MJPanel {
        private boolean iShowArrow = false;
        private boolean iShowHover = false;
        private boolean fSupportsMetadataPopup = false;

        static int getArrowButtonWidth() {
            return ARROW_ICON.getIconWidth();
        }

        private DropDownPanel(LayoutManager layoutManager, boolean bl) {
            super(layoutManager);
            this.fSupportsMetadataPopup = bl;
        }

        private void showArrow(boolean bl) {
            this.iShowArrow = bl;
        }

        public void showHover(boolean bl) {
            this.iShowHover = bl;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.iShowHover) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillRect(0, 0, 1, this.getHeight());
            }
            if (!this.iShowArrow) {
                return;
            }
            if (this.fSupportsMetadataPopup) {
                Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                ARROW_ICON.paintIcon((Component)((Object)this), graphics2D, rectangle.width - ARROW_ICON.getIconWidth(), 0);
            }
            CURRENT_GRIP_ICON.paintIcon((Component)((Object)this), graphics2D, 0, 0);
            graphics2D.dispose();
        }
    }

    static class NamedHeaderContent {
        private final int iRow;
        private final String iName;

        NamedHeaderContent(int n, String string) {
            this.iRow = n;
            this.iName = string;
        }

        String getName() {
            return this.iName;
        }

        int getRow() {
            return this.iRow;
        }

        String getRowID() {
            return Integer.toString(this.iRow);
        }

        public String toString() {
            return this.getRowID() + ":" + this.getName();
        }

        public boolean equals(Object object) {
            if (!(object instanceof NamedHeaderContent)) {
                return false;
            }
            NamedHeaderContent namedHeaderContent = (NamedHeaderContent)object;
            return this.iName.equals(namedHeaderContent.getName()) && this.iRow == namedHeaderContent.getRow();
        }

        public int hashCode() {
            return this.iName.hashCode() + this.iRow * 1000;
        }
    }

    static enum Alignment {
        ROWS,
        COLUMNS;

    }
}

